"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUptimeDataView = exports.UptimeDataViewContextProvider = exports.UptimeDataViewContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_has_data = require("../components/overview/empty_state/use_has_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/contexts/uptime_data_view_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UptimeDataViewContext = exports.UptimeDataViewContext = /*#__PURE__*/(0, _react.createContext)({});
const UptimeDataViewContextProvider = ({
  children,
  dataViews
}) => {
  const {
    settings,
    data: indexStatus
  } = (0, _use_has_data.useHasData)();
  const heartbeatIndices = (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '';
  const {
    data
  } = (0, _public.useFetcher)(async () => {
    if (heartbeatIndices && indexStatus !== null && indexStatus !== void 0 && indexStatus.indexExists) {
      // this only creates an dateView in memory, not as saved object
      return dataViews.create({
        title: heartbeatIndices
      });
    }
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Uptime folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [heartbeatIndices, indexStatus === null || indexStatus === void 0 ? void 0 : indexStatus.indexExists]);
  return /*#__PURE__*/_react.default.createElement(UptimeDataViewContext.Provider, {
    value: data,
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 10
    }
  });
};
exports.UptimeDataViewContextProvider = UptimeDataViewContextProvider;
const useUptimeDataView = () => (0, _react.useContext)(UptimeDataViewContext);
exports.useUptimeDataView = useUptimeDataView;