"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addUpdatedField = addUpdatedField;
exports.useFilterUpdate = exports.parseFiltersMap = void 0;
var _react = require("react");
var _use_url_params = require("./use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseFiltersMap = currentFilters => {
  try {
    return new Map(JSON.parse(currentFilters));
  } catch {
    return new Map();
  }
};
exports.parseFiltersMap = parseFiltersMap;
const getUpdateFilters = (filterKueries, fieldName, values) => {
  // add new term to filter map, toggle it off if already present
  const updatedFilterMap = new Map(filterKueries);
  updatedFilterMap.set(fieldName, values !== null && values !== void 0 ? values : []);
  updatedFilterMap.forEach((value, key) => {
    if (typeof value !== 'undefined' && value.length === 0) {
      updatedFilterMap.delete(key);
    }
  });

  // store the new set of filters
  const persistedFilters = Array.from(updatedFilterMap);
  return persistedFilters.length === 0 ? '' : JSON.stringify(persistedFilters);
};
function addUpdatedField(current, key, updated, objToUpdate) {
  if (current !== updated || current !== '') {
    objToUpdate[key] = updated;
  }
}
const useFilterUpdate = (fieldName, values, notValues, shouldUpdateUrl = true) => {
  const [getUrlParams, updateUrl] = (0, _use_url_params.useUrlParams)();
  const {
    filters,
    excludedFilters
  } = getUrlParams();
  (0, _react.useEffect)(() => {
    const currentFiltersMap = parseFiltersMap(filters);
    const currentExclusionsMap = parseFiltersMap(excludedFilters);
    const newFiltersString = getUpdateFilters(currentFiltersMap, fieldName, values);
    const newExclusionsString = getUpdateFilters(currentExclusionsMap, fieldName, notValues);

    // no new filters to apply
    if (filters === newFiltersString && excludedFilters === newExclusionsString) {
      return;
    }
    const update = {};
    addUpdatedField(filters, 'filters', newFiltersString, update);
    addUpdatedField(excludedFilters, 'excludedFilters', newExclusionsString, update);
    if (shouldUpdateUrl && Object.keys(update).length > 0) {
      // reset pagination whenever filters change
      updateUrl({
        ...update,
        pagination: ''
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [fieldName, values, notValues]);
};
exports.useFilterUpdate = useFilterUpdate;