"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initMonitorStatusAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_monitor_url = require("../../../../common/utils/get_monitor_url");
var _translations = require("../../../../common/rules/legacy_uptime/translations");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/lib/alert_types/monitor_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.MonitorStatusTranslations;
const MonitorStatusAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/monitor_status'))));
let validateFunc;
const initMonitorStatusAlertType = ({
  core,
  plugins,
  isHidden,
  stackVersion
}) => ({
  id: _uptime_alerts.CLIENT_ALERT_TYPES.MONITOR_STATUS,
  description,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.monitorStatus}`;
  },
  ruleParamsExpression: params => /*#__PURE__*/_react.default.createElement(MonitorStatusAlert, {
    core: core,
    plugins: plugins,
    params: params,
    stackVersion: stackVersion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }),
  validate: ruleParams => {
    if (!validateFunc) {
      (async function loadValidate() {
        const {
          validateMonitorStatusParams
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/validate_monitor_status')));
        validateFunc = validateMonitorStatusParams;
      })();
    }
    return validateFunc ? validateFunc(ruleParams) : {};
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: isHidden,
  format: ({
    fields
  }) => ({
    reason: fields[_ruleDataUtils.ALERT_REASON] || '',
    link: (0, _get_monitor_url.getMonitorRouteFromMonitorId)({
      monitorId: fields['monitor.id'],
      dateRangeEnd: fields[_ruleDataUtils.ALERT_STATUS] === _ruleDataUtils.ALERT_STATUS_ACTIVE ? 'now' : fields[_ruleDataUtils.ALERT_END],
      dateRangeStart: (0, _moment.default)(new Date(fields[_ruleDataUtils.ALERT_START])).subtract('5', 'm').toISOString(),
      filters: {
        'observer.geo.name': [fields['observer.geo.name'][0]]
      }
    })
  })
});
exports.initMonitorStatusAlertType = initMonitorStatusAlertType;