"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetMLState = exports.getMLCapabilitiesAction = exports.getExistingMLJobAction = exports.getAnomalyRecordsAction = exports.deleteMLJobAction = exports.createMLJobAction = void 0;
var _reduxActions = require("redux-actions");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resetMLState = exports.resetMLState = (0, _reduxActions.createAction)('RESET_ML_STATE');
const getExistingMLJobAction = exports.getExistingMLJobAction = (0, _utils.createAsyncAction)('GET_EXISTING_ML_JOB');
const createMLJobAction = exports.createMLJobAction = (0, _utils.createAsyncAction)('CREATE_ML_JOB');
const getMLCapabilitiesAction = exports.getMLCapabilitiesAction = (0, _utils.createAsyncAction)('GET_ML_CAPABILITIES');
const deleteMLJobAction = exports.deleteMLJobAction = (0, _utils.createAsyncAction)('DELETE_ML_JOB');
const getAnomalyRecordsAction = exports.getAnomalyRecordsAction = (0, _utils.createAsyncAction)('GET_ANOMALY_RECORDS');