"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchPings = exports.fetchPingHistogram = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchPings = async ({
  dateRange: {
    from,
    to
  },
  ...optional
}) => await _utils.apiService.get(_constants.API_URLS.PINGS, {
  from,
  to,
  ...optional
}, _runtime_types.PingsResponseType);
exports.fetchPings = fetchPings;
const fetchPingHistogram = async ({
  monitorId,
  dateStart,
  dateEnd,
  filters,
  bucketSize,
  query,
  timeZone
}) => {
  const queryParams = {
    dateStart,
    dateEnd,
    monitorId,
    filters,
    bucketSize,
    query,
    timeZone
  };
  return await _utils.apiService.get(_constants.API_URLS.PING_HISTOGRAM, queryParams);
};
exports.fetchPingHistogram = fetchPingHistogram;