"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uptimeRouteWrapper = void 0;
var _coreHttpServer = require("@kbn/core-http-server");
var _lib = require("../lib/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const uptimeRouteWrapper = (uptimeRoute, server) => ({
  ...uptimeRoute,
  options: {
    tags: ['oas-tag:uptime']
  },
  security: {
    authz: {
      requiredPrivileges: ['uptime-read', ...(uptimeRoute !== null && uptimeRoute !== void 0 && uptimeRoute.writeAccess ? ['uptime-write'] : [])]
    }
  },
  handler: async (context, request, response) => {
    const coreContext = await context.core;
    const {
      client: esClient
    } = coreContext.elasticsearch;
    const uptimeEsClient = new _lib.UptimeEsClient(coreContext.savedObjects.client, esClient.asCurrentUser, {
      request,
      uiSettings: coreContext.uiSettings,
      isDev: Boolean(server.isDev)
    });
    const res = await uptimeRoute.handler({
      uptimeEsClient,
      savedObjectsClient: coreContext.savedObjects.client,
      context,
      request,
      response,
      server
    });
    if ((0, _coreHttpServer.isKibanaResponse)(res)) {
      return res;
    }
    return response.ok({
      body: {
        ...res,
        ...(await uptimeEsClient.getInspectData(uptimeRoute.path))
      }
    });
  }
});
exports.uptimeRouteWrapper = uptimeRouteWrapper;