"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlDrilldown = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/image-embeddable-plugin/public");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _public4 = require("@kbn/kibana-react-plugin/public");
var _public5 = require("@kbn/ui-actions-enhanced-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18n2 = require("./i18n");
var _event_variables = require("./variables/event_variables");
var _context_variables = require("./variables/context_variables");
var _global_variables = require("./variables/global_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/drilldowns/url_drilldown/public/lib/url_drilldown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const URL_DRILLDOWN = 'URL_DRILLDOWN';
const getViewMode = context => {
  if ((0, _presentationPublishing.apiCanAccessViewMode)(context.embeddable)) {
    return (0, _presentationPublishing.getInheritedViewMode)(context.embeddable);
  }
  throw new Error('Cannot access view mode');
};
class UrlDrilldown {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", URL_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "minimalLicense", 'gold');
    (0, _defineProperty2.default)(this, "licenseFeatureName", 'URL drilldown');
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n2.txtUrlDrilldownDisplayName);
    (0, _defineProperty2.default)(this, "actionMenuItem", ({
      config,
      context
    }) => {
      const [title, setTitle] = _react.default.useState(config.name);
      const [error, setError] = _react.default.useState();
      _react.default.useEffect(() => {
        const variables = this.getRuntimeVariables(context);
        (0, _public5.urlDrilldownCompileUrl)(title, variables, false).then(result => {
          if (title !== result) setTitle(result);
        }).catch(() => {});

        // eslint-disable-next-line react-hooks/exhaustive-deps
      }, []);
      _react.default.useEffect(() => {
        this.buildUrl(config.config, context).catch(e => {
          setError(e.message);
        });
        // eslint-disable-next-line react-hooks/exhaustive-deps
      }, []);
      return /*#__PURE__*/ /* title is used as a tooltip, EuiToolTip doesn't work in this context menu due to hacky zIndex */_react.default.createElement("span", {
        title: error,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 7
        }
      }, title, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: 'danger',
        size: 'xs',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 3,
        "data-test-subj": 'urlDrilldown-error',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 13
        }
      }, error)) : null);
    });
    (0, _defineProperty2.default)(this, "euiIcon", 'link');
    (0, _defineProperty2.default)(this, "CollectConfig", ({
      config,
      onConfig,
      context
    }) => {
      const [variables, exampleUrl] = _react.default.useMemo(() => [this.getVariableList(context), this.getExampleUrl(context)], [context]);
      return /*#__PURE__*/_react.default.createElement(_public4.KibanaContextProvider, {
        services: {
          settings: this.deps.settings,
          theme: this.deps.theme()
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_public5.UrlDrilldownCollectConfig, {
        variables: variables,
        exampleUrl: exampleUrl,
        config: config,
        onConfig: onConfig,
        syntaxHelpDocsLink: this.deps.getSyntaxHelpDocsLink(),
        variablesHelpDocsLink: this.deps.getVariablesHelpDocsLink(),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "createConfig", () => ({
      url: {
        template: ''
      },
      openInNewTab: true,
      encodeUrl: true
    }));
    (0, _defineProperty2.default)(this, "isConfigValid", config => {
      return !!config.url.template;
    });
    (0, _defineProperty2.default)(this, "isCompatible", async (config, context) => {
      const viewMode = getViewMode(context);
      if (viewMode === 'edit') {
        // check if context is compatible by building the scope
        const scope = this.getRuntimeVariables(context);
        return !!scope;
      }
      try {
        await this.buildUrl(config, context);
        return true;
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(e);
        return false;
      }
    });
    (0, _defineProperty2.default)(this, "getHref", async (config, context) => {
      try {
        const url = await this.buildUrl(config, context);
        return url;
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(e);
        return undefined;
      }
    });
    (0, _defineProperty2.default)(this, "execute", async (config, context) => {
      const url = await this.getHref(config, context);
      if (!url) return;
      if (config.openInNewTab) {
        window.open(url, '_blank', 'noopener');
      } else {
        await this.deps.navigateToUrl(url);
      }
    });
    (0, _defineProperty2.default)(this, "getRuntimeVariables", context => {
      return {
        event: (0, _event_variables.getEventScopeValues)(context),
        context: (0, _context_variables.getContextScopeValues)(context),
        ...this.deps.getGlobalScope()
      };
    });
    (0, _defineProperty2.default)(this, "getVariableList", context => {
      const globalScopeValues = this.deps.getGlobalScope();
      const eventVariables = (0, _event_variables.getEventVariableList)(context);
      const contextVariables = (0, _context_variables.getContextVariableList)(context);
      const globalVariables = (0, _global_variables.getGlobalVariableList)(globalScopeValues);
      return [...eventVariables, ...contextVariables, ...globalVariables];
    });
    (0, _defineProperty2.default)(this, "getExampleUrl", context => {
      switch (context.triggers[0]) {
        case _public.SELECT_RANGE_TRIGGER:
          return 'https://www.example.com/?from={{event.from}}&to={{event.to}}';
        case _public.CONTEXT_MENU_TRIGGER:
        case _public2.IMAGE_CLICK_TRIGGER:
          return 'https://www.example.com/?panel={{context.panel.title}}';
        case _public3.ROW_CLICK_TRIGGER:
          return 'https://www.example.com/keys={{event.keys}}&values={{event.values}}';
        case _public.VALUE_CLICK_TRIGGER:
        default:
          return 'https://www.example.com/?{{event.key}}={{event.value}}';
      }
    });
    this.deps = deps;
  }
  supportedTriggers() {
    return [_public.VALUE_CLICK_TRIGGER, _public.SELECT_RANGE_TRIGGER, _public3.ROW_CLICK_TRIGGER, _public.CONTEXT_MENU_TRIGGER, _public2.IMAGE_CLICK_TRIGGER];
  }
  async buildUrl(config, context) {
    var _config$encodeUrl;
    const scope = this.getRuntimeVariables(context);
    const {
      isValid,
      error,
      invalidUrl
    } = await (0, _public5.urlDrilldownValidateUrlTemplate)(config.url, scope);
    if (!isValid) {
      const errorMessage = _i18n.i18n.translate('xpack.urlDrilldown.invalidUrlErrorMessage', {
        defaultMessage: 'Error building URL: {error} Use drilldown editor to check your URL template. Invalid URL: {invalidUrl}',
        values: {
          error,
          invalidUrl
        }
      });
      throw new Error(errorMessage);
    }
    const doEncode = (_config$encodeUrl = config.encodeUrl) !== null && _config$encodeUrl !== void 0 ? _config$encodeUrl : true;
    const url = await (0, _public5.urlDrilldownCompileUrl)(config.url.template, this.getRuntimeVariables(context), doEncode);
    const validUrl = this.deps.externalUrl.validateUrl(url);
    if (!validUrl) {
      const errorMessage = _i18n.i18n.translate('xpack.urlDrilldown.invalidUrlErrorMessage', {
        defaultMessage: 'Error building URL: external URL was denied. Administrator can configure external URL policies using "externalUrl.policy" setting in kibana.yml. Invalid URL: {invalidUrl}',
        values: {
          invalidUrl: url
        }
      });
      throw new Error(errorMessage);
    }
    return url;
  }
}
exports.UrlDrilldown = UrlDrilldown;