"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toPrimitiveOrUndefined = exports.deleteUndefinedKeys = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toPrimitiveOrUndefined = v => {
  if (typeof v === 'number' || typeof v === 'boolean' || typeof v === 'string' || v === null) return v;
  if (typeof v === 'object' && v instanceof Date) return v.toISOString();
  if (typeof v === 'undefined') return undefined;
  return String(v);
};
exports.toPrimitiveOrUndefined = toPrimitiveOrUndefined;
const deleteUndefinedKeys = obj => {
  Object.keys(obj).forEach(key => {
    if (obj[key] === undefined) {
      delete obj[key];
    }
  });
  return obj;
};
exports.deleteUndefinedKeys = deleteUndefinedKeys;