"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsageCountersService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _moment = _interopRequireDefault(require("moment"));
var _usage_counter = require("./usage_counter");
var _saved_objects = require("./saved_objects");
var _rollups = require("./rollups");
var _search = require("./search");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/* internal */

/* internal */

class UsageCountersService {
  constructor({
    logger,
    retryCount,
    bufferDurationMs
  }) {
    (0, _defineProperty2.default)(this, "stop$", new Rx.Subject());
    (0, _defineProperty2.default)(this, "retryCount", void 0);
    (0, _defineProperty2.default)(this, "bufferDurationMs", void 0);
    (0, _defineProperty2.default)(this, "counterSets", new Map());
    (0, _defineProperty2.default)(this, "source$", new Rx.Subject());
    (0, _defineProperty2.default)(this, "counter$", this.source$.pipe(Rx.multicast(new Rx.Subject()), Rx.refCount()));
    (0, _defineProperty2.default)(this, "flushCache$", new Rx.Subject());
    (0, _defineProperty2.default)(this, "stopCaching$", new Rx.Subject());
    (0, _defineProperty2.default)(this, "repository", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "setup", ({
      savedObjects
    }) => {
      const cache$ = new Rx.ReplaySubject();
      const storingCache$ = new Rx.BehaviorSubject(false);
      // flush cache data from cache -> source
      this.flushCache$.pipe(Rx.exhaustMap(() => cache$), Rx.takeUntil(this.stop$)).subscribe(data => {
        storingCache$.next(true);
        this.source$.next(data);
      });

      // store data into cache when not paused
      storingCache$.pipe(Rx.distinctUntilChanged(), Rx.switchMap(isStoring => isStoring ? Rx.EMPTY : this.source$), Rx.takeUntil(Rx.merge(this.stopCaching$, this.stop$))).subscribe(data => {
        cache$.next(data);
        storingCache$.next(false);
      });

      // register the usage-counter and usage-counters (deprecated) types
      (0, _saved_objects.registerUsageCountersSavedObjectTypes)(savedObjects);
      return {
        createUsageCounter: this.createUsageCounter,
        getUsageCounterByDomainId: this.getUsageCounterByDomainId
      };
    });
    (0, _defineProperty2.default)(this, "start", ({
      savedObjects
    }) => {
      this.stopCaching$.next();
      this.repository = savedObjects.createInternalRepository();
      this.counter$.pipe(/* buffer source events every ${bufferDurationMs} */
      Rx.bufferTime(this.bufferDurationMs),
      /**
       * bufferTime will trigger every ${bufferDurationMs}
       * regardless if source emitted anything or not.
       * using filter will stop cut the pipe short
       */
      Rx.filter(counters => Array.isArray(counters) && counters.length > 0), Rx.map(counters => Object.values(this.mergeCounters(counters))), Rx.takeUntil(this.stop$), Rx.concatMap(counters => this.storeDate$(counters, this.repository))).subscribe(results => {
        this.logger.debug('Store counters into savedObjects', {
          kibana: {
            usageCounters: {
              results
            }
          }
        });
      });
      this.flushCache$.next();

      // we start a regular, timer-based cleanup
      (0, _rollups.registerUsageCountersRollups)({
        logger: this.logger,
        getRegisteredUsageCounters: () => Array.from(this.counterSets.values()),
        internalRepository: this.repository,
        pluginStop$: this.stop$
      });
      return {
        search: this.search
      };
    });
    (0, _defineProperty2.default)(this, "stop", () => {
      this.stop$.next();
      this.stop$.complete();
      return {
        search: this.search
      };
    });
    (0, _defineProperty2.default)(this, "backoffDelay", attempt => Math.pow(2, attempt) * _constants.USAGE_COUNTERS_BACKOFF_DELAY_IN_MS);
    (0, _defineProperty2.default)(this, "createUsageCounter", (domainId, params = {}) => {
      if (this.counterSets.get(domainId)) {
        throw new Error(`Usage counter set "${domainId}" already exists.`);
      }
      const counterSet = new _usage_counter.UsageCounter({
        domainId,
        counter$: this.source$,
        retentionPeriodDays: params.retentionPeriodDays
      });
      this.counterSets.set(domainId, counterSet);
      return counterSet;
    });
    (0, _defineProperty2.default)(this, "getUsageCounterByDomainId", domainId => {
      return this.counterSets.get(domainId);
    });
    (0, _defineProperty2.default)(this, "mergeCounters", counters => {
      const date = _moment.default.now();
      return counters.reduce((acc, counter) => {
        const {
          domainId,
          counterName,
          counterType,
          namespace,
          source
        } = counter;
        const key = (0, _saved_objects.serializeCounterKey)({
          domainId,
          counterName,
          counterType,
          namespace,
          source,
          date
        });
        const existingCounter = acc[key];
        if (!existingCounter) {
          acc[key] = counter;
          return acc;
        }
        acc[key] = {
          ...existingCounter,
          ...counter,
          incrementBy: existingCounter.incrementBy + counter.incrementBy
        };
        return acc;
      }, {});
    });
    (0, _defineProperty2.default)(this, "search", async params => {
      if (!this.repository) {
        throw new Error('Cannot search before this service is started. Please call start() first.');
      }
      return await (0, _search.searchUsageCounters)(this.repository, params);
    });
    this.logger = logger;
    this.retryCount = retryCount;
    this.bufferDurationMs = bufferDurationMs;
  }
  // exponential backoff: 500ms, 1000ms, 2000ms

  storeDate$(counters, soRepository) {
    return Rx.forkJoin(counters.map(metric => Rx.defer(() => (0, _saved_objects.storeCounter)({
      metric,
      soRepository
    })).pipe(Rx.retry({
      count: this.retryCount,
      delay: (error, retryIndex) => {
        this.logger.debug(`Error: ${error.message}, retrying attempt ${retryIndex}`); // extra warning logger
        return Rx.timer(this.backoffDelay(retryIndex));
      }
    }), Rx.catchError(error => {
      this.logger.warn(error);
      return Rx.of(error);
    }))));
  }
}
exports.UsageCountersService = UsageCountersService;