"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAvatarTip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _user_avatar = require("./user_avatar");
var _user_tooltip = require("./user_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-user-profile-components/src/user_avatar_tip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Renders a user avatar with tooltip
 */
const UserAvatarTip = ({
  user,
  avatar,
  ...rest
}) => {
  if (!user) {
    return /*#__PURE__*/_react.default.createElement(_user_avatar.UserAvatar, (0, _extends2.default)({}, rest, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
    user: user,
    avatar: avatar,
    position: "top",
    delay: "regular",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_user_avatar.UserAvatar, (0, _extends2.default)({
    user: user,
    avatar: avatar
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  })));
};
exports.UserAvatarTip = UserAvatarTip;