"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProfilesPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_profiles_selectable = require("./user_profiles_selectable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-user-profile-components/src/user_profiles_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Props of {@link UserProfilesPopover} component
 */

/**
 * Renders a selectable component inside a popover given a list of user profiles
 */
const UserProfilesPopover = ({
  title,
  selectableProps,
  ...popoverProps
}) => {
  const searchInputId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'searchInput',
    conditionalId: selectableProps.searchInputId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    panelPaddingSize: "none",
    initialFocus: `[id="${searchInputId}"]`
  }, popoverProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_user_profiles_selectable.UserProfilesSelectable, (0, _extends2.default)({}, selectableProps, {
    searchInputId: searchInputId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }))));
};
exports.UserProfilesPopover = UserProfilesPopover;