"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserToolTip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_avatar = require("./user_avatar");
var _user_profile = require("./user_profile");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-user-profile-components/src/user_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Props of {@link UserToolTip} component
 */

/**
 * Renders a tooltip with user information
 */
const UserToolTip = ({
  user,
  avatar,
  ...rest
}) => {
  const displayName = (0, _user_profile.getUserDisplayName)(user);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, (0, _extends2.default)({
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_user_avatar.UserAvatar, {
      user: user,
      avatar: avatar,
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      style: {
        minWidth: 0
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 13
      }
    }, displayName), user.email && user.email !== displayName ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 15
      }
    }, user.email) : undefined))
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }));
};
exports.UserToolTip = UserToolTip;