"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoadDistChart = PageLoadDistChart;
var _react = _interopRequireWildcard(require("react"));
var _get_exp_view_filter = require("../../../../services/data/get_exp_view_filter");
var _use_exp_view_attrs = require("./use_exp_view_attrs");
var _use_data_view = require("../local_uifilters/use_data_view");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/charts/page_load_dist_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PageLoadDistChart({
  onPercentileChange,
  breakdown
}) {
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    uxUiFilters,
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const {
    ExploratoryViewEmbeddable
  } = kibana.exploratoryView;
  const onBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    if (!range) {
      return;
    }
    const [minX, maxX] = range;
    onPercentileChange(minX, maxX);
  }, [onPercentileChange]);
  const {
    reportDefinitions,
    time
  } = (0, _use_exp_view_attrs.useExpViewAttributes)();
  const allSeries = [{
    time,
    reportDefinitions,
    dataType: 'ux',
    name: 'page-load-distribution',
    selectedMetricField: _elasticsearch_fieldnames.TRANSACTION_DURATION,
    breakdown: breakdown === null || breakdown === void 0 ? void 0 : breakdown.fieldName,
    filters: (0, _get_exp_view_filter.getExploratoryViewFilter)(uxUiFilters, urlParams)
  }];
  if (!dataViewTitle) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: '300px',
    attributes: allSeries,
    onBrushEnd: onBrushEnd,
    reportType: "data-distribution",
    dataTypesIndexPatterns: {
      ux: dataViewTitle
    },
    legendIsVisible: Boolean(breakdown),
    axisTitlesVisibility: {
      x: true,
      yLeft: true,
      yRight: false
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
}