"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentFilter = EnvironmentFilter;
exports.UxEnvironmentFilter = UxEnvironmentFilter;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _use_environments_fetcher = require("../../../../hooks/use_environments_fetcher");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_ux_url_params = require("../../../../context/url_params_context/use_ux_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/environment_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function updateEnvironmentUrl(history, location, environment) {
  history.push({
    ...location,
    search: (0, _public.fromQuery)({
      ...(0, _public.toQuery)(location.search),
      environment
    })
  });
}
const SEPARATOR_OPTION = {
  text: `- ${_i18n.i18n.translate('xpack.ux.filter.environment.selectEnvironmentLabel', {
    defaultMessage: 'Select environment'
  })} -`,
  disabled: true
};
function getOptions(environments) {
  const environmentOptions = environments.filter(env => env !== _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value).map(environment => ({
    value: environment,
    text: environment
  }));
  return [_environment_filter_values.ENVIRONMENT_ALL, ...(environments.includes(_environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) ? [_environment_filter_values.ENVIRONMENT_NOT_DEFINED] : []), ...(environmentOptions.length > 0 ? [SEPARATOR_OPTION] : []), ...environmentOptions];
}
function EnvironmentFilter({
  start,
  end,
  environment,
  serviceName
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    environments,
    loading
  } = (0, _use_environments_fetcher.useEnvironmentsFetcher)({
    serviceName,
    start,
    end
  });

  // Set the min-width so we don't see as much collapsing of the select during
  // the loading state. 200px is what is looks like if "production" is
  // the contents.
  const minWidth = 200;
  const options = getOptions(environments);
  const environmentLabel = _i18n.i18n.translate('xpack.ux.filter.environment.label', {
    defaultMessage: 'Environment'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "uxEnvironmentFilterSelect",
    fullWidth: true,
    prepend: environmentLabel,
    options: options,
    value: environment,
    onChange: event => {
      updateEnvironmentUrl(history, location, event.target.value);
    },
    isLoading: loading,
    style: {
      minWidth
    },
    "aria-label": environmentLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  });
}
function UxEnvironmentFilter() {
  const {
    urlParams: {
      start,
      end,
      environment,
      serviceName
    }
  } = (0, _use_ux_url_params.useUxUrlParams)();
  return /*#__PURE__*/_react.default.createElement(EnvironmentFilter, {
    start: start,
    end: end,
    environment: environment,
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  });
}