"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RumDatePicker = RumDatePicker;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _use_ux_url_params = require("../../../../context/url_params_context/use_ux_url_params");
var _use_date_range_redirect = require("../../../../hooks/use_date_range_redirect");
var _call_api = require("../../../../services/rest/call_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/rum_datepicker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RumDatePicker() {
  const {
    urlParams: {
      rangeFrom,
      rangeTo,
      refreshPaused,
      refreshInterval
    },
    refreshTimeRange
  } = (0, _use_ux_url_params.useUxUrlParams)();
  const {
    redirect,
    isDateRangeSet
  } = (0, _use_date_range_redirect.useDateRangeRedirect)();
  if (!isDateRangeSet) {
    redirect();
  }
  return /*#__PURE__*/_react.default.createElement(_public.DatePicker, {
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    refreshPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onTimeRangeRefresh: ({
      start,
      end
    }) => {
      (0, _call_api.clearCache)();
      refreshTimeRange({
        rangeFrom: start,
        rangeTo: end
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}