"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPercentile = UserPercentile;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/user_percentile/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_P = 50;
function UserPercentile() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const updatePercentile = (0, _react.useCallback)((percentileN, replaceHistory) => {
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)({
        ...(0, _public.toQuery)(history.location.search),
        percentile: percentileN
      })
    };
    if (replaceHistory) {
      history.replace(newLocation);
    } else {
      history.push(newLocation);
    }
  }, [history]);
  (0, _react.useEffect)(() => {
    if (!percentile) {
      updatePercentile(DEFAULT_P, true);
    }
  });
  const options = [{
    value: '50',
    text: _translations.I18LABELS.percentile50thMedian,
    'data-test-subj': 'p50Percentile'
  }, {
    value: '75',
    text: _translations.I18LABELS.percentile75th,
    'data-test-subj': 'p75Percentile'
  }, {
    value: '90',
    text: _translations.I18LABELS.percentile90th,
    'data-test-subj': 'p90Percentile'
  }, {
    value: '95',
    text: _translations.I18LABELS.percentile95th,
    'data-test-subj': 'p95Percentile'
  }, {
    value: '99',
    text: _translations.I18LABELS.percentile99th,
    'data-test-subj': 'p99Percentile'
  }];
  const onChange = val => {
    updatePercentile(Number(val));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    prepend: _translations.I18LABELS.percentile,
    "data-test-subj": "uxPercentileSelect",
    "aria-label": _translations.I18LABELS.percentile,
    options: options,
    onChange: evt => onChange(evt.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
}