"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPercentileLabel = exports.TBT_TOOLTIP = exports.TBT_LABEL = exports.SUM_LONG_TASKS_TOOLTIP = exports.SUM_LONG_TASKS = exports.NO_OF_LONG_TASK_TOOLTIP = exports.NO_OF_LONG_TASK = exports.LONGEST_LONG_TASK_TOOLTIP = exports.LONGEST_LONG_TASK = exports.FCP_TOOLTIP = exports.FCP_LABEL = exports.DATA_UNDEFINED_LABEL = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_UNDEFINED_LABEL = exports.DATA_UNDEFINED_LABEL = _i18n.i18n.translate('xpack.ux.coreVitals.dataUndefined', {
  defaultMessage: 'N/A'
});
const FCP_LABEL = exports.FCP_LABEL = _i18n.i18n.translate('xpack.ux.coreVitals.fcp', {
  defaultMessage: 'First contentful paint'
});
const FCP_TOOLTIP = exports.FCP_TOOLTIP = _i18n.i18n.translate('xpack.ux.coreVitals.fcpTooltip', {
  defaultMessage: 'First contentful paint (FCP) focusses on the initial rendering and measures the time from when the page starts loading to when any part of the page’s content is displayed on the screen.'
});
const TBT_LABEL = exports.TBT_LABEL = _i18n.i18n.translate('xpack.ux.coreVitals.tbt', {
  defaultMessage: 'Total blocking time'
});
const TBT_TOOLTIP = exports.TBT_TOOLTIP = _i18n.i18n.translate('xpack.ux.coreVitals.tbtTooltip', {
  defaultMessage: 'Total blocking time (TBT) is the sum of the blocking time (duration above 50 ms) for each long task that occurs between the First contentful paint and the time when the transaction is completed.'
});
const NO_OF_LONG_TASK = exports.NO_OF_LONG_TASK = _i18n.i18n.translate('xpack.ux.uxMetrics.noOfLongTasks', {
  defaultMessage: 'No. of long tasks'
});
const NO_OF_LONG_TASK_TOOLTIP = exports.NO_OF_LONG_TASK_TOOLTIP = _i18n.i18n.translate('xpack.ux.uxMetrics.noOfLongTasksTooltip', {
  defaultMessage: 'The number of long tasks, a long task is defined as any user activity or browser task that monopolizes the UI thread for extended periods (greater than 50 milliseconds) and blocks other critical tasks (frame rate or input latency) from being executed.'
});
const LONGEST_LONG_TASK = exports.LONGEST_LONG_TASK = _i18n.i18n.translate('xpack.ux.uxMetrics.longestLongTasks', {
  defaultMessage: 'Longest long task duration'
});
const LONGEST_LONG_TASK_TOOLTIP = exports.LONGEST_LONG_TASK_TOOLTIP = _i18n.i18n.translate('xpack.ux.uxMetrics.longestLongTasksTooltip', {
  defaultMessage: 'The duration of the longest long task, a long task is defined as any user activity or browser task that monopolizes the UI thread for extended periods (greater than 50 milliseconds) and blocks other critical tasks (frame rate or input latency) from being executed.'
});
const SUM_LONG_TASKS = exports.SUM_LONG_TASKS = _i18n.i18n.translate('xpack.ux.uxMetrics.sumLongTasks', {
  defaultMessage: 'Total long tasks duration'
});
const SUM_LONG_TASKS_TOOLTIP = exports.SUM_LONG_TASKS_TOOLTIP = _i18n.i18n.translate('xpack.ux.uxMetrics.sumLongTasksTooltip', {
  defaultMessage: 'The total duration of long tasks, a long task is defined as any user activity or browser task that monopolizes the UI thread for extended periods (greater than 50 milliseconds) and blocks other critical tasks (frame rate or input latency) from being executed.'
});
const getPercentileLabel = value => {
  if (value === 50) return _translations.I18LABELS.median;
  return _i18n.i18n.translate('xpack.ux.percentiles.label', {
    defaultMessage: '{value}th Perc.',
    values: {
      value
    }
  });
};
exports.getPercentileLabel = getPercentileLabel;