"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSACTION_DURATION_REGION = exports.TRANSACTION_DURATION_COUNTRY = exports.REGION_NAME = exports.COUNTRY_NAME = void 0;
exports.useLayerList = useLayerList;
var _apmDataView = require("@kbn/apm-data-view");
var _common = require("@kbn/maps-plugin/common");
var _react = require("react");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _transaction_types = require("../../../../../common/transaction_types");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_ux_plugin_context = require("../../../../context/use_ux_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getWhereQuery = serviceName => {
  return {
    query: `${_elasticsearch_fieldnames.TRANSACTION_TYPE} : "${_transaction_types.TRANSACTION_PAGE_LOAD}" and ${_elasticsearch_fieldnames.SERVICE_NAME} : "${serviceName}"`,
    language: 'kuery'
  };
};
const REGION_NAME = exports.REGION_NAME = 'region_name';
const COUNTRY_NAME = exports.COUNTRY_NAME = 'name';
const TRANSACTION_DURATION_REGION = exports.TRANSACTION_DURATION_REGION = '__kbnjoin__avg_of_transaction.duration.us__e62a1b9c-d7ff-4fd4-a0f6-0fdc44bb9e41';
const TRANSACTION_DURATION_COUNTRY = exports.TRANSACTION_DURATION_COUNTRY = '__kbnjoin__avg_of_transaction.duration.us__3657625d-17b0-41ef-99ba-3a2b2938655c';
function useLayerList() {
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    spaceId
  } = (0, _use_ux_plugin_context.useUxPluginContext)();
  const {
    esTermSourceCountry,
    esTermSourceRegion
  } = (0, _react.useMemo)(() => {
    const _esTermSourceCountry = {
      type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
      id: '3657625d-17b0-41ef-99ba-3a2b2938655c',
      term: 'client.geo.country_iso_code',
      metrics: [{
        type: _common.AGG_TYPE.AVG,
        field: 'transaction.duration.us',
        label: 'Page load duration'
      }],
      indexPatternId: (0, _apmDataView.getStaticDataViewId)(spaceId),
      applyGlobalQuery: true,
      applyGlobalTime: true,
      applyForceRefresh: true
    };
    const _esTermSourceRegion = {
      type: _common.SOURCE_TYPES.ES_TERM_SOURCE,
      id: 'e62a1b9c-d7ff-4fd4-a0f6-0fdc44bb9e41',
      term: 'client.geo.region_iso_code',
      metrics: [{
        type: _common.AGG_TYPE.AVG,
        field: 'transaction.duration.us'
      }],
      whereQuery: {
        query: 'transaction.type : "page-load"',
        language: 'kuery'
      },
      indexPatternId: (0, _apmDataView.getStaticDataViewId)(spaceId),
      applyGlobalQuery: true,
      applyGlobalTime: true,
      applyForceRefresh: true
    };
    return {
      esTermSourceCountry: _esTermSourceCountry,
      esTermSourceRegion: _esTermSourceRegion
    };
  }, [spaceId]);
  const {
    serviceName
  } = urlParams;
  esTermSourceCountry.whereQuery = getWhereQuery(serviceName);
  const getLayerStyle = fieldName => {
    return {
      type: 'VECTOR',
      properties: {
        icon: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            value: 'marker'
          }
        },
        fillColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            color: 'Blue to Red',
            colorCategory: 'palette_0',
            fieldMetaOptions: {
              isEnabled: true,
              sigma: 3
            },
            type: _common.COLOR_MAP_TYPE.ORDINAL,
            field: {
              name: fieldName,
              origin: _common.FIELD_ORIGIN.JOIN
            },
            useCustomColorRamp: false
          }
        },
        lineColor: {
          type: _common.STYLE_TYPE.DYNAMIC,
          options: {
            color: '#3d3d3d',
            fieldMetaOptions: {
              isEnabled: true
            }
          }
        },
        lineWidth: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 1
          }
        },
        iconSize: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 6
          }
        },
        iconOrientation: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            orientation: 0
          }
        },
        labelText: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            value: ''
          }
        },
        labelPosition: {
          options: {
            position: _common.LABEL_POSITIONS.CENTER
          }
        },
        labelZoomRange: {
          options: {
            useLayerZoomRange: true,
            minZoom: 0,
            maxZoom: 24
          }
        },
        labelColor: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            color: '#000000'
          }
        },
        labelSize: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            size: 14
          }
        },
        labelBorderColor: {
          type: _common.STYLE_TYPE.STATIC,
          options: {
            color: '#FFFFFF'
          }
        },
        symbolizeAs: {
          options: {
            value: _common.SYMBOLIZE_AS_TYPES.CIRCLE
          }
        },
        labelBorderSize: {
          options: {
            size: _common.LABEL_BORDER_SIZES.SMALL
          }
        }
      },
      isTimeAware: true
    };
  };
  const pageLoadDurationByCountryLayer = {
    joins: [{
      leftField: 'iso2',
      right: esTermSourceCountry
    }],
    sourceDescriptor: {
      type: 'EMS_FILE',
      id: 'world_countries',
      tooltipProperties: [COUNTRY_NAME]
    },
    style: getLayerStyle(TRANSACTION_DURATION_COUNTRY),
    id: 'e8d1d974-eed8-462f-be2c-f0004b7619b2',
    minZoom: 0,
    maxZoom: 24,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  esTermSourceRegion.whereQuery = getWhereQuery(serviceName);
  const pageLoadDurationByAdminRegionLayer = {
    joins: [{
      leftField: 'region_iso_code',
      right: esTermSourceRegion
    }],
    sourceDescriptor: {
      type: 'EMS_FILE',
      id: 'administrative_regions_lvl2',
      tooltipProperties: ['region_iso_code', REGION_NAME]
    },
    style: getLayerStyle(TRANSACTION_DURATION_REGION),
    id: '0e936d41-8765-41c9-97f0-05e166391366',
    minZoom: 3,
    maxZoom: 24,
    alpha: 0.75,
    visible: true,
    type: _common.LAYER_TYPE.GEOJSON_VECTOR
  };
  return [pageLoadDurationByCountryLayer, pageLoadDurationByAdminRegionLayer];
}