"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clientMetricsQuery = clientMetricsQuery;
var _merge_projection = require("../../../common/utils/merge_projection");
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function clientMetricsQuery(start, end, percentile = 50, urlQuery, uiFilters) {
  const setup = {
    uiFilters: uiFilters ? uiFilters : {}
  };
  const projection = (0, _projections.getRumPageLoadTransactionsProjection)({
    setup,
    urlQuery,
    checkFetchStartFieldExists: false,
    start,
    end
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    size: 0,
    track_total_hits: true,
    aggs: {
      hasFetchStartField: {
        filter: {
          exists: {
            field: 'transaction.marks.navigationTiming.fetchStart'
          }
        },
        aggs: {
          totalPageLoadDuration: {
            percentiles: {
              field: _elasticsearch_fieldnames.TRANSACTION_DURATION,
              percents: [percentile],
              hdr: {
                number_of_significant_value_digits: 3
              }
            }
          },
          backEnd: {
            percentiles: {
              field: _elasticsearch_fieldnames.TRANSACTION_TIME_TO_FIRST_BYTE,
              percents: [percentile],
              hdr: {
                number_of_significant_value_digits: 3
              }
            }
          }
        }
      }
    }
  });
  return params;
}