"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceNameQuery = serviceNameQuery;
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _merge_projection = require("../../../common/utils/merge_projection");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function serviceNameQuery(start, end, uiFilters) {
  const setup = {
    uiFilters: uiFilters ? uiFilters : {}
  };
  const projection = (0, _projections.getRumPageLoadTransactionsProjection)({
    setup,
    start,
    end
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    size: 0,
    query: {
      bool: projection.query.bool
    },
    aggs: {
      services: {
        terms: {
          field: _elasticsearch_fieldnames.SERVICE_NAME,
          size: 1000
        }
      }
    }
  });
  return params;
}