"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggAdd = DefaultEditorAggAdd;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/agg_add.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DefaultEditorAggAdd({
  group = [],
  groupName,
  schemas,
  addSchema,
  stats
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onSelectSchema = schema => {
    setIsPopoverOpen(false);
    addSchema(schema);
  };
  const groupNameLabel = groupName === _public.AggGroupNames.Buckets ? _i18n.i18n.translate('visDefaultEditor.aggAdd.bucketLabel', {
    defaultMessage: 'bucket'
  }) : _i18n.i18n.translate('visDefaultEditor.aggAdd.metricLabel', {
    defaultMessage: 'metric'
  });
  const addButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "plusInCircleFilled",
    "data-test-subj": `visEditorAdd_${groupName}`,
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    "aria-label": _i18n.i18n.translate('visDefaultEditor.aggAdd.addGroupButtonLabel', {
      defaultMessage: 'Add {groupNameLabel}',
      values: {
        groupNameLabel
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addButtonLabel",
    defaultMessage: "Add",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
  const isMaxedCount = schema => {
    const count = group.filter(agg => agg.schema === schema.name).length;
    return count >= schema.max;
  };
  const isSchemaDisabled = (schema, maxedCount) => {
    var _schema$disabled;
    return (_schema$disabled = schema.disabled) !== null && _schema$disabled !== void 0 ? _schema$disabled : maxedCount;
  };
  const maxTooltipText = _i18n.i18n.translate('visDefaultEditor.aggAdd.maxBuckets', {
    defaultMessage: 'Max {groupNameLabel} count reached',
    values: {
      groupNameLabel
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `addGroupButtonPopover_${groupName}`,
    button: addButton,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    closePopover: () => setIsPopoverOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }, (groupName !== _public.AggGroupNames.Buckets || !stats.count) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addGroupButtonLabel",
    defaultMessage: "Add {groupNameLabel}",
    values: {
      groupNameLabel
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }), groupName === _public.AggGroupNames.Buckets && stats.count > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggAdd.addSubGroupButtonLabel",
    defaultMessage: "Add sub-{groupNameLabel}",
    values: {
      groupNameLabel
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: schemas.map(schema => {
      var _schema$tooltip;
      const maxedCount = isMaxedCount(schema);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: `${schema.name}_${schema.title}`,
        "data-test-subj": `visEditorAdd_${groupName}_${schema.title}`,
        disabled: isPopoverOpen && isSchemaDisabled(schema, maxedCount),
        onClick: () => onSelectSchema(schema),
        toolTipContent: (_schema$tooltip = schema.tooltip) !== null && _schema$tooltip !== void 0 ? _schema$tooltip : maxedCount ? maxTooltipText : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 17
        }
      }, schema.title);
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))));
}