"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggGroup = DefaultEditorAggGroup;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _agg = require("./agg");
var _agg_add = require("./agg_add");
var _agg_group_helper = require("./agg_group_helper");
var _agg_group_state = require("./agg_group_state");
var _sidebar = require("../_sidebar.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/agg_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DefaultEditorAggGroup({
  formIsTouched,
  groupName,
  lastParentPipelineAggTitle,
  metricAggs,
  state,
  schemas = [],
  addSchema,
  setAggParamValue,
  setStateParamValue,
  onAggTypeChange,
  onToggleEnableAgg,
  removeAgg,
  reorderAggs,
  setTouched,
  setValidity,
  timeRange
}) {
  const groupNameLabel = _public.AggGroupLabels[groupName];
  // e.g. buckets can have no aggs
  const schemaNames = schemas.map(s => s.name);
  const group = (0, _react.useMemo)(() => {
    var _state$data$aggs;
    return ((_state$data$aggs = state.data.aggs) === null || _state$data$aggs === void 0 ? void 0 : _state$data$aggs.aggs.filter(agg => agg.schema && schemaNames.includes(agg.schema))) || [];
  }, [state.data.aggs, schemaNames]);
  const stats = {
    max: 0,
    count: group.length
  };
  schemas.forEach(schema => {
    stats.max += schema.max;
  });
  const [aggsState, setAggsState] = (0, _react.useReducer)(_agg_group_state.aggGroupReducer, group, _agg_group_state.initAggsState);
  const bucketsError = lastParentPipelineAggTitle && groupName === _public.AggGroupNames.Buckets && !group.length ? _i18n.i18n.translate('visDefaultEditor.buckets.mustHaveBucketErrorMessage', {
    defaultMessage: 'Add a bucket with "Date Histogram" or "Histogram" aggregation.',
    description: 'Date Histogram and Histogram should not be translated'
  }) : undefined;
  const isGroupValid = !bucketsError && Object.values(aggsState).every(item => item.valid);
  const isAllAggsTouched = (0, _agg_group_helper.isInvalidAggsTouched)(aggsState);
  const isMetricAggregationDisabled = (0, _react.useMemo)(() => groupName === _public.AggGroupNames.Metrics && (0, _agg_group_helper.getEnabledMetricAggsCount)(group) === 1, [groupName, group]);
  (0, _react.useEffect)(() => {
    // when isAllAggsTouched is true, it means that all invalid aggs are touched and we will set ngModel's touched to true
    // which indicates that Apply button can be changed to Error button (when all invalid ngModels are touched)
    setTouched(isAllAggsTouched);
  }, [isAllAggsTouched, setTouched]);
  (0, _react.useEffect)(() => {
    // when not all invalid aggs are touched and formIsTouched becomes true, it means that Apply button was clicked.
    // and in such case we set touched state to true for all aggs
    if (formIsTouched && !isAllAggsTouched) {
      Object.keys(aggsState).map(([aggId]) => {
        setAggsState({
          type: _agg_group_state.AGGS_ACTION_KEYS.TOUCHED,
          payload: true,
          aggId
        });
      });
    }
    // adding all of the values to the deps array cause a circular re-render
    // the logic should be rewised
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formIsTouched]);
  (0, _react.useEffect)(() => {
    setValidity(`aggGroup__${groupName}`, isGroupValid);
  }, [groupName, isGroupValid, setValidity]);
  const onDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    if (source && destination) {
      reorderAggs(group[source.index], group[destination.index]);
    }
  }, [reorderAggs, group]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${groupName}AggGroup`,
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, groupNameLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }), bucketsError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "bucketsError",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, bucketsError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: `agg_group_dnd_${groupName}`,
    className: "visEditorSidebar__collapsible--marginBottom",
    css: _sidebar.visEditorSidebarStyles.collapsibleMarginBottom,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.map((agg, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    key: agg.id,
    index: index,
    draggableId: `agg_group_dnd_${groupName}_${agg.id}`,
    customDragHandle: true,
    disableInteractiveElementBlocking: true // Allows button to be drag handle
    ,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 15
    }
  }, provided => /*#__PURE__*/_react.default.createElement(_agg.DefaultEditorAgg, {
    agg: agg,
    aggIndex: index,
    aggIsTooLow: (0, _agg_group_helper.calcAggIsTooLow)(agg, index, group, schemas),
    dragHandleProps: provided.dragHandleProps || null,
    formIsTouched: aggsState[agg.id] ? aggsState[agg.id].touched : false,
    groupName: groupName,
    isDraggable: stats.count > 1,
    isLastBucket: groupName === _public.AggGroupNames.Buckets && index === group.length - 1,
    isRemovable: (0, _agg_group_helper.isAggRemovable)(agg, group, schemas),
    isDisabled: agg.schema === 'metric' && isMetricAggregationDisabled,
    lastParentPipelineAggTitle: lastParentPipelineAggTitle,
    metricAggs: metricAggs,
    state: state,
    setAggParamValue: setAggParamValue,
    setStateParamValue: setStateParamValue,
    onAggTypeChange: onAggTypeChange,
    onToggleEnableAgg: onToggleEnableAgg,
    removeAgg: removeAgg,
    setAggsState: setAggsState,
    schemas: schemas,
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  }))))), stats.max > stats.count && /*#__PURE__*/_react.default.createElement(_agg_add.DefaultEditorAggAdd, {
    group: group,
    groupName: groupName,
    schemas: schemas,
    stats: stats,
    addSchema: addSchema,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  })));
}