"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGG_TYPE_ACTION_KEYS = exports.AGG_PARAMS_ACTION_KEYS = void 0;
exports.aggParamsReducer = aggParamsReducer;
exports.aggTypeReducer = aggTypeReducer;
exports.initAggParamsState = initAggParamsState;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AGG_TYPE_ACTION_KEYS = exports.AGG_TYPE_ACTION_KEYS = /*#__PURE__*/function (AGG_TYPE_ACTION_KEYS) {
  AGG_TYPE_ACTION_KEYS["TOUCHED"] = "aggTypeTouched";
  AGG_TYPE_ACTION_KEYS["VALID"] = "aggTypeValid";
  return AGG_TYPE_ACTION_KEYS;
}({});
function aggTypeReducer(state, action) {
  switch (action.type) {
    case AGG_TYPE_ACTION_KEYS.TOUCHED:
      return {
        ...state,
        touched: action.payload
      };
    case AGG_TYPE_ACTION_KEYS.VALID:
      return {
        ...state,
        valid: action.payload
      };
    default:
      throw new Error();
  }
}
let AGG_PARAMS_ACTION_KEYS = exports.AGG_PARAMS_ACTION_KEYS = /*#__PURE__*/function (AGG_PARAMS_ACTION_KEYS) {
  AGG_PARAMS_ACTION_KEYS["TOUCHED"] = "aggParamsTouched";
  AGG_PARAMS_ACTION_KEYS["VALID"] = "aggParamsValid";
  AGG_PARAMS_ACTION_KEYS["RESET"] = "aggParamsReset";
  return AGG_PARAMS_ACTION_KEYS;
}({});
function aggParamsReducer(state, {
  type,
  paramName = '',
  payload
}) {
  const targetParam = state[paramName] || {
    valid: true,
    touched: false
  };
  switch (type) {
    case AGG_PARAMS_ACTION_KEYS.TOUCHED:
      return {
        ...state,
        [paramName]: {
          ...targetParam,
          touched: payload
        }
      };
    case AGG_PARAMS_ACTION_KEYS.VALID:
      return {
        ...state,
        [paramName]: {
          ...targetParam,
          valid: payload
        }
      };
    case AGG_PARAMS_ACTION_KEYS.RESET:
      return {};
    default:
      throw new Error();
  }
}
function initAggParamsState(params) {
  const state = params.reduce((stateObj, param) => {
    stateObj[param.aggParam.name] = {
      valid: true,
      touched: false
    };
    return stateObj;
  }, {});
  return state;
}