"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxBarsParamEditor = MaxBarsParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/max_bars.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const autoPlaceholder = _i18n.i18n.translate('visDefaultEditor.controls.maxBars.autoPlaceholder', {
  defaultMessage: 'Auto'
});
const label = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "visDefaultEditor.controls.maxBars.maxBarsLabel",
  defaultMessage: "Max bars",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  position: "right",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.maxBars.maxBarsHelpText",
    defaultMessage: "Intervals will be selected automatically based on the available data. The maximum number of bars can never be greater than the Advanced Setting's {histogramMaxBars}",
    values: {
      histogramMaxBars: _public2.UI_SETTINGS.HISTOGRAM_MAX_BARS
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }),
  type: "question",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}));
function MaxBarsParamEditor({
  disabled,
  iconTip,
  value,
  setValue,
  showValidation,
  setValidity,
  setTouched
}) {
  var _services$uiSettings;
  const {
    services
  } = (0, _public.useKibana)();
  const uiSettingMaxBars = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get(_public2.UI_SETTINGS.HISTOGRAM_MAX_BARS);
  const isValid = disabled || value === undefined || value === '' || Number(value) > 0 || value < uiSettingMaxBars;
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  const onChange = (0, _react.useCallback)(ev => setValue(ev.target.value === '' ? '' : parseFloat(ev.target.value)), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: value || '',
    placeholder: autoPlaceholder,
    onChange: onChange,
    min: 1,
    fullWidth: true,
    compressed: true,
    max: uiSettingMaxBars,
    isInvalid: showValidation ? !isValid : false,
    onBlur: setTouched,
    disabled: disabled,
    "data-test-subj": "maxBarsParamEditor",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
}