"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_OPTIONS = void 0;
exports.MetricAggParamEditor = MetricAggParamEditor;
exports.aggFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/metric_agg.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const aggFilter = exports.aggFilter = ['!top_hits', '!top_metrics', '!percentiles', '!percentile_ranks', '!median', '!std_dev'];
const EMPTY_VALUE = 'EMPTY_VALUE';
const DEFAULT_OPTIONS = exports.DEFAULT_OPTIONS = [{
  text: '',
  value: EMPTY_VALUE,
  hidden: true
}];
function MetricAggParamEditor({
  agg,
  value,
  showValidation,
  setValue,
  setValidity,
  setTouched,
  metricAggs = []
}) {
  const label = _i18n.i18n.translate('visDefaultEditor.controls.metricLabel', {
    defaultMessage: 'Metric'
  });
  const isValid = !!value;
  (0, _utils.useValidation)(setValidity, isValid);
  (0, _utils.useFallbackMetric)(setValue, aggFilter, metricAggs, value);
  const filteredMetrics = (0, _react.useMemo)(() => metricAggs.filter(respAgg => respAgg.type.name !== agg.type.name), [metricAggs, agg.type.name]);
  const options = (0, _utils.useAvailableOptions)(aggFilter, filteredMetrics, DEFAULT_OPTIONS);
  const onChange = (0, _react.useCallback)(e => setValue(e.target.value), [setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    fullWidth: true,
    options: options,
    value: value || EMPTY_VALUE,
    onChange: onChange,
    isInvalid: showValidation && !isValid,
    onBlur: setTouched,
    "data-test-subj": `visEditorSubAggMetric${agg.id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
}