"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RawJsonParamEditor = RawJsonParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/raw_json.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RawJsonParamEditor({
  showValidation,
  value = '',
  setValidity,
  setValue,
  setTouched
}) {
  const [isFieldValid, setFieldValidity] = (0, _react.useState)(true);
  const editorTooltipText = (0, _react.useMemo)(() => _i18n.i18n.translate('visDefaultEditor.controls.jsonInputTooltip', {
    defaultMessage: "Any JSON formatted properties you add here will be merged with the elasticsearch aggregation definition for this section. For example 'shard_size' on a terms aggregation."
  }), []);
  const jsonEditorLabelText = (0, _react.useMemo)(() => _i18n.i18n.translate('visDefaultEditor.controls.jsonInputLabel', {
    defaultMessage: 'JSON input'
  }), []);
  const label = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jsonEditorLabelText, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: editorTooltipText,
    type: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), [jsonEditorLabelText, editorTooltipText]);
  const onChange = (0, _react.useCallback)(newValue => {
    setValue(newValue);
    // validation for value
    let isJsonValid = true;
    try {
      if (newValue) {
        JSON.parse(_public.XJson.collapseLiteralStrings(newValue));
      }
    } catch (e) {
      isJsonValid = false;
    }
    setFieldValidity(isJsonValid);
    setValidity(isJsonValid);
  }, [setValidity, setFieldValidity, setValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: showValidation ? !isFieldValid : false,
    fullWidth: true,
    display: "rowCompressed",
    onBlur: setTouched,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    "aria-label": jsonEditorLabelText,
    "aria-describedby": "jsonEditorDescription",
    languageId: _monaco.XJsonLang.ID,
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    width: "100%",
    height: "250px",
    value: value,
    onChange: onChange,
    options: {
      renderValidationDecorations: value ? 'on' : 'off',
      lineNumbers: 'on',
      fontSize: 14,
      minimap: {
        enabled: false
      },
      scrollBeyondLastLine: false,
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })));
}