"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateStateParams = exports.toggleEnabledAgg = exports.setStateParamValue = exports.setAggParamValue = exports.reorderAggs = exports.removeAgg = exports.discardChanges = exports.changeAggType = exports.addNewAgg = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const addNewAgg = schema => ({
  type: _constants.EditorStateActionTypes.ADD_NEW_AGG,
  payload: {
    schema
  }
});
exports.addNewAgg = addNewAgg;
const discardChanges = vis => ({
  type: _constants.EditorStateActionTypes.DISCARD_CHANGES,
  payload: {
    vis
  }
});
exports.discardChanges = discardChanges;
const changeAggType = (aggId, value) => ({
  type: _constants.EditorStateActionTypes.CHANGE_AGG_TYPE,
  payload: {
    aggId,
    value
  }
});
exports.changeAggType = changeAggType;
const setAggParamValue = (aggId, paramName, value) => ({
  type: _constants.EditorStateActionTypes.SET_AGG_PARAM_VALUE,
  payload: {
    aggId,
    paramName,
    value
  }
});
exports.setAggParamValue = setAggParamValue;
const setStateParamValue = (paramName, value) => ({
  type: _constants.EditorStateActionTypes.SET_STATE_PARAM_VALUE,
  payload: {
    paramName,
    value
  }
});
exports.setStateParamValue = setStateParamValue;
const removeAgg = (aggId, schemas) => ({
  type: _constants.EditorStateActionTypes.REMOVE_AGG,
  payload: {
    aggId,
    schemas
  }
});
exports.removeAgg = removeAgg;
const reorderAggs = (sourceAgg, destinationAgg) => ({
  type: _constants.EditorStateActionTypes.REORDER_AGGS,
  payload: {
    sourceAgg,
    destinationAgg
  }
});
exports.reorderAggs = reorderAggs;
const toggleEnabledAgg = (aggId, enabled) => ({
  type: _constants.EditorStateActionTypes.TOGGLE_ENABLED_AGG,
  payload: {
    aggId,
    enabled
  }
});
exports.toggleEnabledAgg = toggleEnabledAgg;
const updateStateParams = params => ({
  type: _constants.EditorStateActionTypes.UPDATE_STATE_PARAMS,
  payload: {
    params
  }
});
exports.updateStateParams = updateStateParams;