"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangesPanel = RangesPanel;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/gauge/public/editor/components/gauge/ranges_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RangesPanel({
  showElasticChartsOptions,
  setGaugeValue,
  setTouched,
  setValidity,
  setValue,
  stateParams,
  uiState
}) {
  const setColorSchemaOptions = (0, _react.useCallback)((paramName, value) => {
    setGaugeValue(paramName, value);
    // set outline if color schema is changed to greys
    // if outline wasn't set explicitly yet
    if (paramName === 'colorSchema' && value === _public2.ColorSchemas.Greys && typeof stateParams.gauge.outline === 'undefined') {
      setGaugeValue('outline', true);
    }
  }, [setGaugeValue, stateParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeGauge.controls.gaugeOptions.rangesTitle",
    defaultMessage: "Ranges",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ColorRanges, {
    "data-test-subj": "gaugeColorRange",
    colorsRange: stateParams.gauge.colorsRange,
    setValue: setGaugeValue,
    setTouched: setTouched,
    setValidity: setValidity,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    disabled: showElasticChartsOptions || stateParams.gauge.colorsRange.length < 2,
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.autoExtendRangeLabel', {
      defaultMessage: 'Auto extend range'
    }),
    tooltip: showElasticChartsOptions ? _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.extendRangeTooltipNotAvailable', {
      defaultMessage: 'The new charts library supports only extended ranges. To disable it, please, enable the gauge legacy charts library advanced setting.'
    }) : _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.extendRangeTooltip', {
      defaultMessage: 'Extends range to the maximum value in your data.'
    }),
    paramName: "extendRange",
    value: stateParams.gauge.extendRange,
    setValue: setGaugeValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.PercentageModeOption, {
    "data-test-subj": "gaugePercentageMode",
    percentageMode: stateParams.gauge.percentageMode,
    formatPattern: stateParams.gauge.percentageFormatPattern,
    setValue: setGaugeValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.ColorSchemaOptions, {
    disabled: stateParams.gauge.colorsRange.length < 2,
    colorSchema: stateParams.gauge.colorSchema,
    colorSchemas: _public2.colorSchemas,
    invertColors: stateParams.gauge.invertColors,
    uiState: uiState,
    setValue: setColorSchemaOptions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, (0, _extends2.default)({
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showOutline', {
      defaultMessage: 'Show outline'
    }),
    paramName: "outline",
    value: stateParams.gauge.outline,
    setValue: setGaugeValue,
    disabled: showElasticChartsOptions
  }, showElasticChartsOptions ? {
    tooltip: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showOutlineNotAvailable', {
      defaultMessage: 'The outline is not supported with the new charts library. Please, enable the gauge legacy charts library advanced setting.'
    })
  } : {}, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, (0, _extends2.default)({
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showLegendLabel', {
      defaultMessage: 'Show legend'
    }),
    paramName: "addLegend",
    value: stateParams.addLegend,
    setValue: setValue,
    disabled: showElasticChartsOptions
  }, showElasticChartsOptions ? {
    tooltip: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showLegendNotAvailable', {
      defaultMessage: 'The legend is not supported with the new charts library. Please, enable the gauge legacy charts library advanced setting.'
    })
  } : {}, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeGauge.controls.gaugeOptions.showScaleLabel', {
      defaultMessage: 'Show scale'
    }),
    paramName: "show",
    value: stateParams.gauge.scale.show,
    setValue: (paramName, value) => setGaugeValue('scale', {
      ...stateParams.gauge.scale,
      [paramName]: value
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }));
}