"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisBasic = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _table_vis_cell = require("./table_vis_cell");
var _utils = require("../utils");
var _table_vis_controls = require("./table_vis_controls");
var _table_vis_columns = require("./table_vis_columns");
var _utils2 = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/table/public/components/table_vis_basic.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TableVisBasic = exports.TableVisBasic = /*#__PURE__*/(0, _react.memo)(({
  fireEvent,
  table,
  visConfig,
  title,
  uiStateProps: {
    columnsWidth,
    sort,
    setColumnsWidth,
    setSort
  }
}) => {
  var _dataGridRef$current;
  const dataGridRef = (0, _react.useRef)(null);
  const {
    columns,
    rows,
    formattedColumns
  } = table;

  // custom sorting is in place until the EuiDataGrid sorting gets rid of flaws -> https://github.com/elastic/eui/issues/4108
  const sortedRows = (0, _react.useMemo)(() => {
    if (sort.columnIndex !== null && sort.direction) {
      var _columns$sort$columnI;
      const id = (_columns$sort$columnI = columns[sort.columnIndex]) === null || _columns$sort$columnI === void 0 ? void 0 : _columns$sort$columnI.id;
      return (0, _utils2.sortNullsLast)(rows, sort.direction, id);
    }
    return rows;
  }, [columns, rows, sort.columnIndex, sort.direction]);

  // renderCellValue is a component which renders a cell based on column and row indexes
  const renderCellValue = (0, _react.useMemo)(() => (0, _table_vis_cell.createTableVisCell)(sortedRows, formattedColumns, visConfig.autoFitRowToContent), [formattedColumns, sortedRows, visConfig.autoFitRowToContent]);
  const rowHeightsOptions = (0, _react.useMemo)(() => visConfig.autoFitRowToContent ? {
    defaultHeight: 'auto'
  } : undefined, [visConfig.autoFitRowToContent]);

  // Columns config
  const gridColumns = (0, _table_vis_columns.createGridColumns)(columns, sortedRows, formattedColumns, columnsWidth, fireEvent, (_dataGridRef$current = dataGridRef.current) === null || _dataGridRef$current === void 0 ? void 0 : _dataGridRef$current.closeCellPopover);

  // Pagination config
  const pagination = (0, _utils.usePagination)(visConfig, rows.length);
  // Sorting config
  const sortingColumns = (0, _react.useMemo)(() => {
    var _columns$sort$columnI2;
    return sort.columnIndex !== null && sort.direction ? [{
      id: (_columns$sort$columnI2 = columns[sort.columnIndex]) === null || _columns$sort$columnI2 === void 0 ? void 0 : _columns$sort$columnI2.id,
      direction: sort.direction
    }] : [];
  }, [columns, sort]);
  const onSort = (0, _react.useCallback)(sortingCols => {
    // data table vis sorting now only handles one column sorting
    // if data grid provides more columns to sort, pick only the next column to sort
    const newSortValue = sortingCols.length <= 1 ? sortingCols[0] : sortingCols[1];
    setSort(newSortValue && {
      columnIndex: columns.findIndex(c => c.id === newSortValue.id),
      direction: newSortValue.direction
    });
  }, [columns, setSort]);
  const dataGridAriaLabel = title || visConfig.title || _i18n.i18n.translate('visTypeTable.defaultAriaLabel', {
    defaultMessage: 'Data table visualization'
  });
  const onColumnResize = (0, _react.useCallback)(({
    columnId,
    width
  }) => {
    const colIndex = columns.findIndex(c => c.id === columnId);
    setColumnsWidth({
      colIndex,
      width
    });
  }, [columns, setColumnsWidth]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "aria-label": dataGridAriaLabel,
    columns: gridColumns,
    gridStyle: {
      border: 'horizontal',
      header: 'underline'
    },
    rowHeightsOptions: rowHeightsOptions,
    rowCount: rows.length,
    columnVisibility: {
      visibleColumns: columns.map(({
        id
      }) => id),
      setVisibleColumns: () => {}
    },
    toolbarVisibility: visConfig.showToolbar && {
      showColumnSelector: false,
      showFullScreenSelector: false,
      showSortSelector: false,
      showDisplaySelector: false,
      additionalControls: /*#__PURE__*/_react.default.createElement(_table_vis_controls.TableVisControls, {
        dataGridAriaLabel: dataGridAriaLabel,
        columns: columns
        // csv exports sorted table
        ,
        rows: sortedRows,
        filename: visConfig.title,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 17
        }
      })
    },
    renderCellValue: renderCellValue,
    renderFooterCellValue: visConfig.showTotal ? ({
      columnId
    }) => formattedColumns[columnId].formattedTotal || null : undefined,
    pagination: pagination,
    sorting: {
      columns: sortingColumns,
      onSort
    },
    onColumnResize: onColumnResize,
    minSizeForControls: 1,
    ref: dataGridRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }));
});