"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGridColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/table/public/components/table_vis_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createGridColumns = (columns, rows, formattedColumns, columnsWidth, fireEvent, closeCellPopover) => {
  const onFilterClick = (data, negate) => {
    fireEvent({
      name: 'filter',
      data: {
        data: [{
          table: {
            columns,
            rows
          },
          ...data,
          column: data.column
        }],
        negate
      }
    });
  };
  return columns.map((col, colIndex) => {
    const formattedColumn = formattedColumns[col.id];
    const cellActions = formattedColumn.filterable ? [({
      rowIndex,
      columnId,
      Component
    }) => {
      var _rows$rowIndex;
      // incoming data might change and put the current page out of bounds - check whether row actually exists
      const rowValue = (_rows$rowIndex = rows[rowIndex]) === null || _rows$rowIndex === void 0 ? void 0 : _rows$rowIndex[columnId];
      if (rowValue == null) return null;
      const cellContent = formattedColumn.formatter.convert(rowValue);
      const filterForText = _i18n.i18n.translate('visTypeTable.tableCellFilter.filterForValueText', {
        defaultMessage: 'Filter for'
      });
      const filterForAriaLabel = _i18n.i18n.translate('visTypeTable.tableCellFilter.filterForValueAriaLabel', {
        defaultMessage: 'Filter for: {cellContent}',
        values: {
          cellContent
        }
      });
      return /*#__PURE__*/_react.default.createElement(Component, {
        "aria-label": filterForAriaLabel,
        "data-test-subj": "tbvChartCell__filterForCellValue",
        onClick: () => {
          onFilterClick({
            row: rowIndex,
            column: colIndex,
            value: rowValue
          }, false);
          closeCellPopover === null || closeCellPopover === void 0 ? void 0 : closeCellPopover();
        },
        iconType: "plusInCircle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 15
        }
      }, filterForText);
    }, ({
      rowIndex,
      columnId,
      Component
    }) => {
      var _rows$rowIndex2;
      // incoming data might change and put the current page out of bounds - check whether row actually exists
      const rowValue = (_rows$rowIndex2 = rows[rowIndex]) === null || _rows$rowIndex2 === void 0 ? void 0 : _rows$rowIndex2[columnId];
      if (rowValue == null) return null;
      const cellContent = formattedColumn.formatter.convert(rowValue);
      const filterOutText = _i18n.i18n.translate('visTypeTable.tableCellFilter.filterOutValueText', {
        defaultMessage: 'Filter out'
      });
      const filterOutAriaLabel = _i18n.i18n.translate('visTypeTable.tableCellFilter.filterOutValueAriaLabel', {
        defaultMessage: 'Filter out: {cellContent}',
        values: {
          cellContent
        }
      });
      return /*#__PURE__*/_react.default.createElement(Component, {
        "aria-label": filterOutAriaLabel,
        onClick: () => {
          onFilterClick({
            row: rowIndex,
            column: colIndex,
            value: rowValue
          }, true);
          closeCellPopover === null || closeCellPopover === void 0 ? void 0 : closeCellPopover();
        },
        iconType: "minusInCircle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 15
        }
      }, filterOutText);
    }] : undefined;
    const initialWidth = columnsWidth.find(c => c.colIndex === colIndex);
    const column = {
      id: col.id,
      display: col.name,
      displayAsText: col.name,
      actions: {
        showHide: false,
        showMoveLeft: false,
        showMoveRight: false,
        showSortAsc: {
          label: _i18n.i18n.translate('visTypeTable.sort.ascLabel', {
            defaultMessage: 'Sort asc'
          })
        },
        showSortDesc: {
          label: _i18n.i18n.translate('visTypeTable.sort.descLabel', {
            defaultMessage: 'Sort desc'
          })
        }
      },
      cellActions
    };
    if (initialWidth) {
      column.initialWidth = initialWidth.width;
    }
    return column;
  });
};
exports.createGridColumns = createGridColumns;