"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _table_vis_basic = require("./table_vis_basic");
var _table_vis_split = require("./table_vis_split");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/table/public/components/table_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableVisualizationStyles = {
  base: euiThemeContext => (0, _react2.css)`
    display: flex;
    flex-direction: column;
    flex: 1 0 0;
    overflow: auto;

    ${(0, _eui.euiScrollBarStyles)(euiThemeContext)}
  `,
  splitColumns: (0, _react2.css)({
    flexDirection: 'row',
    alignItems: 'flex-start'
  })
};
const TableVisualizationComponent = ({
  core,
  handlers,
  visData: {
    direction,
    table,
    tables
  },
  visConfig,
  renderComplete
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(tableVisualizationStyles);
  (0, _react.useLayoutEffect)(() => {
    // Temporary solution: DataGrid should provide onRender callback
    setTimeout(() => {
      renderComplete();
    }, 300);
  }, [renderComplete]);
  const uiStateProps = (0, _utils.useUiState)(handlers.uiState);
  const hasColumnDirection = direction === 'column';
  const className = (0, _classnames.default)('tbvChart', {
    // eslint-disable-next-line @typescript-eslint/naming-convention
    tbvChart__splitColumns: hasColumnDirection
  });
  return /*#__PURE__*/_react.default.createElement(core.i18n.Context, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: core,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    "data-test-subj": "tbvChart",
    css: [styles.base, hasColumnDirection && styles.splitColumns],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, table ? /*#__PURE__*/_react.default.createElement(_table_vis_basic.TableVisBasic, {
    fireEvent: handlers.event,
    table: table,
    visConfig: visConfig,
    uiStateProps: uiStateProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_table_vis_split.TableVisSplit, {
    fireEvent: handlers.event,
    tables: tables,
    visConfig: visConfig,
    uiStateProps: uiStateProps,
    enforceMinWidth: direction === 'column',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }))));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = TableVisualizationComponent;
module.exports = exports.default;