"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelionInterval = TimelionInterval;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/vis-default-editor-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/timelion/public/components/timelion_interval.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  isValidEsInterval
} = _public.search.aggs;
const intervalOptions = [{
  label: _i18n.i18n.translate('timelion.vis.interval.auto', {
    defaultMessage: 'Auto'
  }),
  value: 'auto'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.second', {
    defaultMessage: '1 second'
  }),
  value: '1s'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.minute', {
    defaultMessage: '1 minute'
  }),
  value: '1m'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.hour', {
    defaultMessage: '1 hour'
  }),
  value: '1h'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.day', {
    defaultMessage: '1 day'
  }),
  value: '1d'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.week', {
    defaultMessage: '1 week'
  }),
  value: '1w'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.month', {
    defaultMessage: '1 month'
  }),
  value: '1M'
}, {
  label: _i18n.i18n.translate('timelion.vis.interval.year', {
    defaultMessage: '1 year'
  }),
  value: '1y'
}];
function TimelionInterval({
  value,
  setValue,
  setValidity
}) {
  const onCustomInterval = (0, _react.useCallback)(customValue => {
    setValue(customValue.trim());
  }, [setValue]);
  const onChange = (0, _react.useCallback)(opts => {
    setValue(opts[0] && opts[0].value || '');
  }, [setValue]);
  const selectedOptions = (0, _react.useMemo)(() => [intervalOptions.find(op => op.value === value) || {
    label: value,
    value
  }], [value]);
  const isValid = intervalOptions.some(int => int.value === value) || isValidEsInterval(value);
  (0, _public2.useValidation)(setValidity, isValid);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    helpText: _i18n.i18n.translate('timelion.vis.selectIntervalHelpText', {
      defaultMessage: 'Select an option or create a custom value. Examples: 30s, 20m, 24h, 2d, 1w, 1M'
    }),
    isInvalid: !isValid,
    error: !isValid && _i18n.i18n.translate('timelion.vis.invalidIntervalErrorMessage', {
      defaultMessage: 'Invalid interval format.'
    }),
    label: _i18n.i18n.translate('timelion.vis.intervalLabel', {
      defaultMessage: 'Interval'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    fullWidth: true,
    isInvalid: !isValid,
    onChange: onChange,
    onCreateOption: onCustomInterval,
    options: intervalOptions,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    placeholder: _i18n.i18n.translate('timelion.vis.selectIntervalPlaceholder', {
      defaultMessage: 'Select an interval'
    }),
    "data-test-subj": "timelionIntervalComboBox",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }));
}