"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggRow = AggRow;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _add_delete_buttons = require("../add_delete_buttons");
var _series_drag_handler = require("../series_drag_handler");
var _common = require("../../styles/common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/agg_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function AggRow(props) {
  let iconType = 'eyeClosed';
  let iconColor = 'subdued';
  const lastSibling = (0, _lodash.last)(props.siblings);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (lastSibling.id === props.model.id) {
    iconType = 'eye';
    iconColor = 'text';
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _common.tsvbEditorRowStyles)(euiTheme),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "aggRow",
    gutterSize: "s",
    alignItems: "flexStart",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    color: iconColor,
    css: {
      marginTop: euiTheme.size.xs
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _common.aggRowChildrenStyles)(euiTheme),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, props.children), /*#__PURE__*/_react.default.createElement(_series_drag_handler.SeriesDragHandler, {
    dragHandleProps: props.dragHandleProps,
    hideDragHandler: props.disableDelete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    testSubj: "addMetric",
    addTooltip: _i18n.i18n.translate('visTypeTimeseries.aggRow.addMetricButtonTooltip', {
      defaultMessage: 'Add Metric'
    }),
    deleteTooltip: _i18n.i18n.translate('visTypeTimeseries.aggRow.deleteMetricButtonTooltip', {
      defaultMessage: 'Delete Metric'
    }),
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    disableDelete: props.disableDelete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }))));
}