"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _react2 = require("@emotion/react");
var _services = require("../../services");
var _add_delete_buttons = require("./add_delete_buttons");
var _color_picker = require("./color_picker");
var _field_select = require("./aggs/field_select");
var _index_pattern_select = require("./lib/index_pattern_select");
var _query_bar_wrapper = require("./query_bar_wrapper");
var _yes_no = require("./yes_no");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
var _get_default_query_language = require("./lib/get_default_query_language");
var _icon_select = require("./icon_select/icon_select");
var _common = require("../styles/common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/annotation_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RESTRICT_FIELDS = [_public.KBN_FIELD_TYPES.DATE];
const INDEX_PATTERN_KEY = 'index_pattern';
const TIME_FIELD_KEY = 'time_field';
const useEditorStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return (0, _react2.css)({
      marginBottom: euiTheme.size.base,
      padding: euiTheme.size.s
    });
  }, [euiTheme]);
  return styles;
};
const getAnnotationDefaults = () => ({
  fields: '',
  template: '',
  index_pattern: '',
  query_string: {
    query: '',
    language: (0, _get_default_query_language.getDefaultQueryLanguage)()
  }
});
const AnnotationRow = ({
  annotation,
  fields,
  onChange,
  handleAdd,
  handleDelete
}) => {
  var _fetchedIndex$indexPa, _fetchedIndex$indexPa2, _fetchedIndex$default;
  const model = (0, _react.useMemo)(() => ({
    ...getAnnotationDefaults(),
    ...annotation
  }), [annotation]);
  const htmlId = (0, _eui.htmlIdGenerator)(model.id);
  const [fetchedIndex, setFetchedIndex] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const editorStyles = useEditorStyles();
  (0, _react.useEffect)(() => {
    const updateFetchedIndex = async index => {
      const dataViews = (0, _services.getDataViewsStart)();
      let fetchedIndexPattern = {
        indexPattern: undefined,
        indexPatternString: undefined
      };
      try {
        fetchedIndexPattern = index ? await (0, _index_patterns_utils.fetchIndexPattern)(index, dataViews, {
          fetchKibanaIndexForStringIndexes: true
        }) : {
          ...fetchedIndexPattern,
          defaultIndex: await dataViews.getDefault()
        };
      } catch {
        if ((0, _index_patterns_utils.isDataViewTypeIndexPattern)(index)) {
          fetchedIndexPattern.missedIndex = index.id;
        }
      }
      setFetchedIndex(fetchedIndexPattern);
    };
    updateFetchedIndex(model.index_pattern);
  }, [model.index_pattern]);
  const togglePanelActivation = (0, _react.useCallback)(() => onChange({
    hidden: !model.hidden
  }), [model.hidden, onChange]);
  const handleChange = (0, _react.useCallback)(name => event => {
    var _event$;
    return onChange({
      [name]: Array.isArray(event) ? event === null || event === void 0 ? void 0 : (_event$ = event[0]) === null || _event$ === void 0 ? void 0 : _event$.value : event.target.value
    });
  }, [onChange]);
  const handleQueryChange = (0, _react.useCallback)(filter => onChange({
    query_string: filter
  }), [onChange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbAnnotationsEditor",
    key: model.id,
    css: editorStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
    disableTrash: true,
    onChange: onChange,
    name: "color",
    value: model.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _common.aggRowChildrenStyles)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_index_pattern_select.IndexPatternSelect, {
    indexPatternName: INDEX_PATTERN_KEY,
    onChange: onChange,
    fetchedIndex: fetchedIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    type: TIME_FIELD_KEY,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.timeFieldLabel",
      defaultMessage: "Time field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 19
      }
    }),
    restrict: RESTRICT_FIELDS,
    value: model[TIME_FIELD_KEY],
    onChange: value => {
      var _value$;
      return onChange({
        [TIME_FIELD_KEY]: (_value$ = value === null || value === void 0 ? void 0 : value[0]) !== null && _value$ !== void 0 ? _value$ : undefined
      });
    },
    indexPattern: model.index_pattern,
    placeholder: (_fetchedIndex$indexPa = fetchedIndex === null || fetchedIndex === void 0 ? void 0 : (_fetchedIndex$indexPa2 = fetchedIndex.indexPattern) === null || _fetchedIndex$indexPa2 === void 0 ? void 0 : _fetchedIndex$indexPa2.timeFieldName) !== null && _fetchedIndex$indexPa !== void 0 ? _fetchedIndex$indexPa : fetchedIndex === null || fetchedIndex === void 0 ? void 0 : (_fetchedIndex$default = fetchedIndex.defaultIndex) === null || _fetchedIndex$default === void 0 ? void 0 : _fetchedIndex$default.timeFieldName,
    fields: fields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('queryString'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.queryStringLabel",
      defaultMessage: "Query string",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
    query: {
      language: model.query_string.language || (0, _get_default_query_language.getDefaultQueryLanguage)(),
      query: model.query_string.query || ''
    },
    onChange: handleQueryChange,
    indexPatterns: [model.index_pattern],
    "data-test-subj": "annotationQueryBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.annotationsEditor.ignoreGlobalFiltersLabel', {
      defaultMessage: 'Ignore global filters?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.ignore_global_filters,
    name: "ignore_global_filters",
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.annotationsEditor.ignorePanelFiltersLabel', {
      defaultMessage: 'Ignore panel filters?'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.ignore_panel_filters,
    name: "ignore_panel_filters",
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('icon'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.iconLabel",
      defaultMessage: "Icon (required)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_icon_select.IconSelect, {
    value: model.icon,
    onChange: handleChange('icon'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('fields'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.fieldsLabel",
      defaultMessage: "Fields (required - comma separated paths)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 19
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleChange('fields'),
    value: model.fields,
    fullWidth: true,
    "data-test-subj": "annotationFieldsInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('rowTemplate'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.rowTemplateLabel",
      defaultMessage: "Row template (required)",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 19
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.annotationsEditor.rowTemplateHelpText",
      defaultMessage: "eg.{rowTemplateExample}",
      values: {
        rowTemplateExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 300,
            columnNumber: 53
          }
        }, '{{field}}')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 297,
        columnNumber: 21
      }
    })),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleChange('template'),
    value: model.template,
    fullWidth: true,
    "data-test-subj": "annotationRowTemplateInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_add_delete_buttons.AddDeleteButtons, {
    onAdd: handleAdd,
    onDelete: handleDelete,
    togglePanelActivation: togglePanelActivation,
    isPanelActive: !model.hidden,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  }))));
};
exports.AnnotationRow = AnnotationRow;