"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = ColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable jsx-a11y/click-events-have-key-events */
// The color picker is not yet accessible.
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COMMAS_NUMS_ONLY_RE = /[^0-9,]/g;
function ColorPicker({
  name,
  value,
  disableTrash = false,
  onChange
}) {
  const initialColorValue = value !== null && value !== void 0 && value.includes('rgba') ? value.replace(COMMAS_NUMS_ONLY_RE, '') : value;
  const [color, setColor] = (0, _react.useState)(initialColorValue || '');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleColorChange = (text, {
    rgba,
    hex,
    isValid
  }) => {
    setColor(text);
    if (!isValid) {
      return;
    }
    onChange({
      [name]: hex ? `rgba(${rgba.join(',')})` : ''
    });
  };
  const handleClear = () => {
    setColor('');
    onChange({
      [name]: null
    });
  };
  const label = value ? _i18n.i18n.translate('visTypeTimeseries.colorPicker.notAccessibleWithValueAriaLabel', {
    defaultMessage: 'Color picker ({value}), not accessible',
    values: {
      value
    }
  }) : _i18n.i18n.translate('visTypeTimeseries.colorPicker.notAccessibleAriaLabel', {
    defaultMessage: 'Color picker, not accessible'
  });
  const tsvbColorPickerStyles = (0, _react2.css)`
    display: flex;
    align-items: center;
    position: relative;
  `;
  const tsvbColorPickerClearStyles = (0, _react2.css)`
    margin-left: ${euiTheme.size.xs};
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: tsvbColorPickerStyles,
    "data-test-subj": "tvbColorPicker",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: handleColorChange,
    color: color,
    secondaryInputDisplay: "top",
    showAlpha: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
      color: color,
      "aria-label": label,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 17
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), !disableTrash && /*#__PURE__*/_react.default.createElement("div", {
    css: tsvbColorPickerClearStyles,
    onClick: handleClear,
    "data-test-subj": "tvbColorPickerClear",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "s",
    type: "cross",
    color: "danger",
    content: _i18n.i18n.translate('visTypeTimeseries.colorPicker.clearIconLabel', {
      defaultMessage: 'Clear'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  })));
}