"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchModePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _services = require("../../../../services");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/lib/index_pattern_select/switch_mode_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const allowStringIndicesMessage = _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.allowStringIndices', {
  defaultMessage: 'Allow string indices in TSVB'
});
const SwitchModePopover = ({
  onModeChange,
  useKibanaIndices
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const switchMode = (0, _react.useCallback)(() => {
    onModeChange(!useKibanaIndices);
  }, [onModeChange, useKibanaIndices]);
  const {
    application
  } = (0, _services.getCoreStart)();
  const canEditAdvancedSettings = application.capabilities.advancedSettings.save;
  const handleAllowStringIndicesLinkClick = (0, _react.useCallback)(() => application.navigateToApp('management', {
    path: `/kibana/settings?query=${_constants.UI_SETTINGS.ALLOW_STRING_INDICES}`
  }), [application]);
  const stringIndicesAllowed = (0, _services.getUISettings)().get(_constants.UI_SETTINGS.ALLOW_STRING_INDICES);
  const isSwitchDisabled = useKibanaIndices && !stringIndicesAllowed;
  let allowStringIndicesLabel;
  if (!stringIndicesAllowed) {
    allowStringIndicesLabel = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.indexPatternSelect.switchModePopover.enableAllowStringIndices",
      defaultMessage: "To query Elasticsearch indices, you must enable the {allowStringIndices} setting.",
      values: {
        allowStringIndices: canEditAdvancedSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          color: "accent",
          onClick: handleAllowStringIndicesLinkClick,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 13
          }
        }, allowStringIndicesMessage) : /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 13
          }
        }, allowStringIndicesMessage)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'gear',
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.areaLabel', {
        defaultMessage: 'Configure data view selection mode'
      }),
      onClick: onButtonClick,
      "data-test-subj": "switchIndexPatternSelectionModePopoverButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    css: {
      height: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '360px'
    },
    "data-test-subj": "switchIndexPatternSelectionModePopoverContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.title', {
    defaultMessage: 'Data view mode'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.indexPatternSelect.switchModePopover.text",
    defaultMessage: "A data view groups and retrieves data from Elasticsearch. Disable this mode to directly query Elasticsearch indices instead. {allowStringIndicesLabel}",
    values: {
      allowStringIndicesLabel
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: useKibanaIndices,
    label: _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.switchModePopover.useKibanaIndices', {
      defaultMessage: 'Use Kibana data views'
    }),
    onChange: switchMode,
    disabled: isSwitchDisabled,
    "data-test-subj": "switchIndexPatternSelectionMode",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  })));
};
exports.SwitchModePopover = SwitchModePopover;