"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricPanelConfig = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _color_rules = require("../color_rules");
var _yes_no = require("../yes_no");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _get_default_query_language = require("../lib/get_default_query_language");
var _ui_restrictions = require("../../../../common/ui_restrictions");
var _enums = require("../../../../common/enums");
var _types = require("./types");
var _panel_config = require("./_panel_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/panel_config/metric.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MetricPanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    if (!model.background_color_rules || model.background_color_rules && model.background_color_rules.length === 0) {
      this.props.onChange({
        background_color_rules: [{
          id: (0, _uuid.v4)()
        }]
      });
    }
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    var _model$filter, _model$filter2;
    const {
      selectedTab
    } = this.state;
    const defaults = {
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      }
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const htmlId = (0, _eui.htmlIdGenerator)();
    const view = selectedTab === _types.PANEL_CONFIG_TABS.DATA ? /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
      colorPicker: false,
      fields: this.props.fields,
      limit: _ui_restrictions.limitOfSeries[_enums.PANEL_TYPES.METRIC],
      model: this.props.model,
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container",
      css: _panel_config.panelConfigContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.dataLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      allowIndexSwitchingMode: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('panelFilter'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.metric.optionsTab.panelFilterLabel",
        defaultMessage: "Panel filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 21
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
      },
      onChange: filter => {
        this.props.onChange({
          filter
        });
      },
      indexPatterns: [model.index_pattern],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.metric.optionsTab.ignoreGlobalFilterLabel', {
        defaultMessage: 'Ignore global filter?'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.ignore_global_filter,
      name: "ignore_global_filter",
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.colorRulesLabel",
      defaultMessage: "Color rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_color_rules.ColorRules, {
      model: model,
      onChange: this.props.onChange,
      name: "background_color_rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 13
      }
    })));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "metricEditorDataBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.dataTab.dataButtonLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "metricEditorPanelOptionsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.metric.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    }))), view);
  }
}
exports.MetricPanelConfig = MetricPanelConfig;