"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Series = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _series = require("./vis_types/timeseries/series");
var _series2 = require("./vis_types/metric/series");
var _series3 = require("./vis_types/top_n/series");
var _series4 = require("./vis_types/table/series");
var _series5 = require("./vis_types/gauge/series");
var _series6 = require("./vis_types/markdown/series");
var _i18nReact = require("@kbn/i18n-react");
var _vis_data_context = require("../contexts/vis_data_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/series.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lookup = {
  top_n: _series3.TopNSeries,
  table: _series4.TableSeries,
  metric: _series2.MetricSeries,
  timeseries: _series.TimeseriesSeries,
  gauge: _series5.GaugeSeries,
  markdown: _series6.MarkdownSeries
};
class Series extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      visible: true,
      selectedTab: 'metrics'
    });
    (0, _defineProperty2.default)(this, "switchTab", selectedTab => {
      this.setState({
        selectedTab
      });
    });
    (0, _defineProperty2.default)(this, "handleChange", part => {
      if (this.props.onChange) {
        const {
          model
        } = this.props;
        const doc = (0, _lodash.assign)({}, model, part);
        this.props.onChange(doc);
      }
    });
    (0, _defineProperty2.default)(this, "togglePanelActivation", () => {
      const {
        model
      } = this.props;
      this.handleChange({
        hidden: !model.hidden
      });
    });
    (0, _defineProperty2.default)(this, "toggleVisible", e => {
      e.preventDefault();
      this.setState({
        visible: !this.state.visible
      });
    });
  }
  render() {
    const {
      panel
    } = this.props;
    const Component = lookup[panel.type];
    return Boolean(Component) ? /*#__PURE__*/_react.default.createElement(_vis_data_context.VisDataContext.Consumer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    }, visData => {
      const series = (0, _lodash.get)(visData, `${panel.id}.series`, []);
      const counter = {};
      const seriesQuantity = series.reduce((acc, value) => {
        counter[value.seriesId] = counter[value.seriesId] + 1 || 1;
        acc[value.seriesId] = counter[value.seriesId];
        return acc;
      }, {});
      return /*#__PURE__*/_react.default.createElement(Component, {
        className: this.props.className,
        disableAdd: this.props.disableAdd,
        uiRestrictions: visData.uiRestrictions,
        seriesQuantity: seriesQuantity,
        disableDelete: this.props.disableDelete,
        fields: this.props.fields,
        name: this.props.name,
        onAdd: this.props.onAdd,
        onChange: this.handleChange,
        onClone: this.props.onClone,
        onDelete: this.props.onDelete,
        model: this.props.model,
        panel: this.props.panel,
        selectedTab: this.state.selectedTab,
        style: this.props.style,
        switchTab: this.switchTab,
        toggleVisible: this.toggleVisible,
        togglePanelActivation: this.togglePanelActivation,
        visible: this.state.visible,
        dragHandleProps: this.props.dragHandleProps,
        indexPatternForQuery: panel.index_pattern,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 13
        }
      });
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.missingSeriesComponentDescription",
      defaultMessage: "Missing Series component for panel type: {panelType}",
      values: {
        panelType: panel.type
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 7
      }
    });
  }
}
exports.Series = Series;
Series.defaultProps = {
  name: 'metrics'
};
Series.propTypes = {
  className: _propTypes.default.string,
  disableAdd: _propTypes.default.bool,
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  name: _propTypes.default.string,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onClone: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  dragHandleProps: _propTypes.default.object
};