"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBySelect = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _check_ui_restrictions = require("../../../../common/check_ui_restrictions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/splits/group_by_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getAvailableOptions = () => [{
  label: _i18n.i18n.translate('visTypeTimeseries.splits.groupBySelect.modeOptions.everythingLabel', {
    defaultMessage: 'Everything'
  }),
  value: 'everything'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.splits.groupBySelect.modeOptions.filterLabel', {
    defaultMessage: 'Filter'
  }),
  value: 'filter'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.splits.groupBySelect.modeOptions.filtersLabel', {
    defaultMessage: 'Filters'
  }),
  value: 'filters'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.splits.groupBySelect.modeOptions.termsLabel', {
    defaultMessage: 'Terms'
  }),
  value: 'terms'
}];
const GroupBySelect = ({
  id,
  onChange,
  value = 'everything',
  uiRestrictions
}) => {
  const modeOptions = getAvailableOptions().map(field => ({
    ...field,
    disabled: !(0, _check_ui_restrictions.isGroupByFieldsEnabled)(field.value, uiRestrictions)
  }));
  const selectedOption = modeOptions.find(option => value === option.value);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: id,
    isClearable: false,
    options: modeOptions,
    selectedOptions: selectedOption ? [selectedOption] : undefined,
    onChange: onChange,
    singleSelection: {
      asPlainText: true
    },
    "data-test-subj": "groupBySelect",
    "aria-label": _i18n.i18n.translate('visTypeTimeseries.splits.groupBySelect.ariaLabel', {
      defaultMessage: 'Group by mode'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
};
exports.GroupBySelect = GroupBySelect;