"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _enums = require("../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const tabs = [{
  type: _enums.PANEL_TYPES.TIMESERIES,
  label: _i18n.i18n.translate('visTypeTimeseries.visPicker.timeSeriesLabel', {
    defaultMessage: 'Time Series'
  })
}, {
  type: _enums.PANEL_TYPES.METRIC,
  label: _i18n.i18n.translate('visTypeTimeseries.visPicker.metricLabel', {
    defaultMessage: 'Metric'
  })
}, {
  type: _enums.PANEL_TYPES.TOP_N,
  label: _i18n.i18n.translate('visTypeTimeseries.visPicker.topNLabel', {
    defaultMessage: 'Top N'
  })
}, {
  type: _enums.PANEL_TYPES.GAUGE,
  label: _i18n.i18n.translate('visTypeTimeseries.visPicker.gaugeLabel', {
    defaultMessage: 'Gauge'
  })
}, {
  type: _enums.PANEL_TYPES.MARKDOWN,
  label: 'Markdown'
}, {
  type: _enums.PANEL_TYPES.TABLE,
  label: _i18n.i18n.translate('visTypeTimeseries.visPicker.tableLabel', {
    defaultMessage: 'Table'
  })
}];
const VisPicker = ({
  onChange,
  currentVisType
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, tabs.map(({
    label,
    type
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: type,
    isSelected: type === currentVisType,
    onClick: () => onChange({
      type
    }),
    "data-test-subj": `${type}TsvbTypeBtn`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, label)));
};
exports.VisPicker = VisPicker;