"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MarkdownVisualization;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _error = require("../../error");
var _replace_vars = require("../../lib/replace_vars");
var _convert_series_to_vars = require("../../lib/convert_series_to_vars");
var _set_is_reversed = require("../../../lib/set_is_reversed");
var _vis_types = require("../_vis_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_types/markdown/vis.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const markdownStyles = (0, _react2.css)`
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  position: relative;
`;
const markdownContentStyles = (0, _react2.css)`
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  overflow: hidden;

  &.tvbMarkdown__content--middle {
    justify-content: center;
  }

  &.tvbMarkdown__content--bottom {
    justify-content: flex-end;
  }

  &.tvbMarkdown__content-isScrolling {
    overflow: auto;
  }
`;
function MarkdownVisualization(props) {
  const {
    backgroundColor,
    model,
    visData,
    getConfig,
    fieldFormatMap,
    initialRender,
    indexPattern
  } = props;
  const series = (0, _lodash.get)(visData, `${model.id}.series`, []);
  const variables = (0, _convert_series_to_vars.convertSeriesToVars)(series, model, getConfig, fieldFormatMap, indexPattern);
  const panelBackgroundColor = model.background_color || backgroundColor;
  const style = {
    backgroundColor: panelBackgroundColor
  };
  const isReversed = (0, _react.useMemo)(() => (0, _set_is_reversed.isBackgroundInverted)(panelBackgroundColor), [panelBackgroundColor]);
  let markdown;
  if (model.markdown) {
    const markdownSource = (0, _replace_vars.replaceVars)(model.markdown, {}, {
      _all: variables,
      ...variables
    });
    const contentClasses = (0, _classnames.default)('eui-scrollBar', 'tvbMarkdown__content', `tvbMarkdown__content--${model.markdown_vertical_align}`, {
      'tvbMarkdown__content-isScrolling': model.markdown_scrollbars
    });
    const markdownError = markdownSource instanceof Error ? markdownSource : null;
    markdown = /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbMarkdown",
      css: markdownStyles,
      "data-test-subj": "tsvbMarkdown",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }, markdownError && /*#__PURE__*/_react.default.createElement(_error.ErrorComponent, {
      error: markdownError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 27
      }
    }), /*#__PURE__*/_react.default.createElement(_react2.ClassNames, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, ({
      css,
      cx
    }) => /*#__PURE__*/_react.default.createElement("div", {
      className: cx(contentClasses,
      // wrapping select for markdown body to make sure selector specificity wins over base styles
      css([`.kbnMarkdown__body {
                      ${model.markdown_css}
                    }`], markdownContentStyles)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, !markdownError && /*#__PURE__*/_react.default.createElement(_public.Markdown, {
      isReversed: isReversed,
      onRender: initialRender,
      markdown: markdownSource,
      openLinksInNewTab: model.markdown_openLinksInNewTab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    })))));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbVis",
    css: _vis_types.visStyles,
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, markdown);
}
MarkdownVisualization.propTypes = {
  backgroundColor: _propTypes.default.string,
  className: _propTypes.default.string,
  model: _propTypes.default.object,
  onBrush: _propTypes.default.func,
  onFilterClick: _propTypes.default.func,
  onChange: _propTypes.default.func,
  visData: _propTypes.default.object,
  getConfig: _propTypes.default.func
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;