"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visWithSplits = visWithSplits;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _get_display_name = require("./lib/get_display_name");
var _empty_label = require("../../../common/empty_label");
var _get_split_by_terms_color = require("../lib/get_split_by_terms_color");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_with_splits.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const splitVisStyle = (0, _react2.css)`
  width: 100%;
  display: flex;
  /* Allow wrapping beyond 4 in a row */
  flex-wrap: wrap;
  /* Space out each vis instead of clumping in the center to utilize more horizontal space */
  justify-content: space-around;
  /* Stretch all the heights so that prior to wrapping the vis' take up the full panel height */
  align-items: stretch;
`;
const splitVisOneStyle = (0, _react2.css)`
  flex: 1;

  .tvbSplitVis__split {
    min-width: 0;

    > .tvbVis {
      min-height: 0;
    }
  }
`;
const useSplitVisItemStyle = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => {
    return (0, _react2.css)`
      /* This maintains that each vis will be at least 1/4 of the panel's width
        but it will also grow to fill the space if there are less than 4 in a row */
      flex: 1 0 25%;
      /* Ensure a minimum width is achieved on smaller width panels */
      min-width: calc(${euiTheme.size.base} * 12);
      display: flex;

      > .tvbVis {
        /* Apply the minimum height on the vis itself so it doesn't interfere with flex calculations
          Gauges are not completely square, so the height is just slightly less than the width */
        min-height: calc(${euiTheme.size.base} * 12 / 1.25);
      }
    `;
  }, [euiTheme]);
  return styles;
};
function visWithSplits(WrappedComponent) {
  function SplitVisComponent(props) {
    const {
      model,
      visData,
      syncColors,
      palettesService,
      fieldFormatMap
    } = props;
    const getSeriesColor = (0, _react.useCallback)((seriesName, seriesId, baseColor) => {
      const palette = {
        ...model.series[0].palette,
        name: model.series[0].split_color_mode === 'kibana' ? 'kibana_palette' : model.series[0].split_color_mode || model.series[0].palette.name
      };
      const props = {
        seriesById: visData[model.id].series,
        seriesName,
        seriesId,
        baseColor,
        seriesPalette: palette,
        palettesRegistry: palettesService,
        syncColors,
        fieldFormatMap
      };
      return (0, _get_split_by_terms_color.getSplitByTermsColor)(props) || null;
    }, [fieldFormatMap, model.id, model.series, palettesService, syncColors, visData]);
    const splitVisItemStyle = useSplitVisItemStyle();
    if (!model || !visData || !visData[model.id]) return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 58
      }
    }));
    if (visData[model.id].series.every(s => s.id.split(_constants.SERIES_SEPARATOR).length === 1)) {
      return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 14
        }
      }));
    }
    const splitsVisData = visData[model.id].series.reduce((acc, series) => {
      const [seriesId, splitId] = series.id.split(_constants.SERIES_SEPARATOR);
      const seriesModel = model.series.find(s => s.id === seriesId);
      if (!seriesModel) return acc;
      const label = series.splitByLabel;
      if (!acc[splitId]) {
        acc[splitId] = {
          series: [],
          label: series.label.toString()
        };
      }
      const labelHasKeyPlaceholder = /{{\s*key\s*}}/.test(seriesModel.label);
      const color = series.color || seriesModel.color;
      const finalColor = model.series[0].split_mode === 'terms' ? getSeriesColor(label, series.id, color) : color;
      acc[splitId].series.push({
        ...series,
        id: seriesId,
        color: finalColor,
        label: seriesModel.label && !labelHasKeyPlaceholder ? seriesModel.label : label
      });
      return acc;
    }, {});
    const nonSplitSeries = (0, _lodash.first)(visData[model.id].series.filter(series => {
      const seriesModel = model.series.find(s => s.id === series.id);
      if (!seriesModel) return false;
      return ['everything', 'filter'].includes(seriesModel.split_mode);
    }));
    const indexOfNonSplit = nonSplitSeries ? (0, _lodash.findIndex)(model.series, s => s.id === nonSplitSeries.id) : null;
    const rows = Object.keys(splitsVisData).map((key, index, arrayRef) => {
      const splitData = splitsVisData[key];
      const {
        series,
        label
      } = splitData;
      const additionalLabel = label;
      const newSeries = indexOfNonSplit != null && indexOfNonSplit > 0 ? [...series, nonSplitSeries] : [nonSplitSeries, ...series];
      const newVisData = {
        [model.id]: {
          id: model.id,
          series: newSeries || series
        }
      };
      return /*#__PURE__*/_react.default.createElement("div", {
        key: key,
        className: "tvbSplitVis__split",
        css: splitVisItemStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(WrappedComponent, {
        model: model,
        visData: newVisData,
        onBrush: props.onBrush,
        onFilterClick: props.onFilterClick,
        additionalLabel: (0, _empty_label.getValueOrEmpty)(additionalLabel),
        backgroundColor: props.backgroundColor,
        getConfig: props.getConfig,
        fieldFormatMap: props.fieldFormatMap,
        initialRender: arrayRef.length - 1 === index ? props.initialRender : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 11
        }
      }));
    });
    const hasOneVis = visData[model.id].series.length === 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('tvbSplitVis', {
        'tvbSplitVis--one': hasOneVis
      }),
      css: [splitVisStyle, hasOneVis && splitVisOneStyle],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 7
      }
    }, rows);
  }
  SplitVisComponent.displayName = `SplitVisComponent(${(0, _get_display_name.getDisplayName)(WrappedComponent)})`;
  return SplitVisComponent;
}