"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.valueSecondaryStyle = exports.secondaryContainerStyle = exports.labelSecondaryStyle = exports.labelPrimaryStyle = exports.Metric = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _last_value_utils = require("../../../../common/last_value_utils");
var _calculate_coordinates = require("../lib/calculate_coordinates");
var _render_counter = require("../../components/render_counter");
var _variables = require("./_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/visualizations/views/metric.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * 1. Text is scaled using a matrix so all font sizes and related metrics
 *    are being calculated from a percentage of the base font size of 100% (14px).
 */

// Helper function to create styles for reversed elements
const createReversedStyles = styles => (0, _react2.css)`
  .tvbVisMetric--reversed & {
    ${styles}
  }
`;
const containerStyle = (0, _react2.css)`
  font-size: 100%; /* 1 */
  position: relative;
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
`;
const resizeStyle = (0, _react2.css)`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
  overflow: hidden;
  display: flex;
`;
const innerStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: absolute;
  padding: ${euiTheme.size.xs} ${euiTheme.size.s} ${euiTheme.size.s};
`;
const labelPrimaryStyle = ({
  euiTheme
}) => {
  const vars = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    color: ${vars.tvbTextColor};
    text-align: center;
    font-size: 0.5em; /* 1 */
    margin-bottom: 0.25em; /* 1 */
    line-height: 1em; /* 1 */

    ${createReversedStyles(`color: ${vars.tvbTextColorReversed};`)}
  `;
};
exports.labelPrimaryStyle = labelPrimaryStyle;
const valuePrimaryStyle = ({
  euiTheme
}) => {
  const vars = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    color: ${vars.tvbValueColor};
    text-align: center;
    font-size: 1em; /* 1 */
    font-weight: ${euiTheme.font.weight.bold};
    line-height: 1em; /* 1 */

    ${createReversedStyles(`color: ${vars.tvbValueColorReversed};`)}
  `;
};
const secondaryContainerStyle = exports.secondaryContainerStyle = (0, _react2.css)`
  display: flex;
  justify-content: center;
  align-items: center;
  margin-top: 0.05em; /* 1 */
`;
const labelSecondaryStyle = ({
  euiTheme
}) => {
  const vars = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    font-size: 0.35em; /* 1 */
    margin-right: 0.3em; /* 1 */
    color: ${vars.tvbTextColor};
    line-height: 1em; /* 1 */

    ${createReversedStyles(`color: ${vars.tvbTextColorReversed};`)}
  `;
};
exports.labelSecondaryStyle = labelSecondaryStyle;
const valueSecondaryStyle = ({
  euiTheme
}) => {
  const vars = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    font-size: 0.35em; /* 1 */
    color: ${vars.tvbValueColor};
    line-height: 1em; /* 1 */

    ${createReversedStyles(`color: ${vars.tvbValueColorReversed};`)}
  `;
};
exports.valueSecondaryStyle = valueSecondaryStyle;
const labelAdditionalStyle = ({
  euiTheme
}) => {
  const vars = (0, _variables.getVisVariables)({
    euiTheme
  });
  return (0, _react2.css)`
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    font-size: 0.25em; /* 1 */
    padding: calc(${euiTheme.size.xs} / 2) 0 0;
    text-align: center;
    color: ${vars.tvbValueColor};
    line-height: 1.2; // Ensure the descenders don't get cut off

    ${createReversedStyles(`color: ${vars.tvbValueColorReversed};`)}
  `;
};
class Metric extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      scale: 1,
      left: 0,
      top: 0,
      translateX: 1,
      translateY: 1,
      resized: false
    };
    this.handleResize = this.handleResize.bind(this);
    this.checkResizeThrottled = _lodash.default.throttle(() => {
      const newState = (0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state);
      if (newState && this.state && !_lodash.default.isEqual(newState, this.state)) {
        this.handleResize();
      }
    }, 200);
  }
  componentWillUnmount() {
    clearTimeout(this.timeout);
  }
  componentDidMount() {
    this.handleResize();
  }
  handleResize() {
    // Bingo!
    this.setState({
      ...(0, _calculate_coordinates.calculateCoordinates)(this.inner, this.resize, this.state),
      resized: true
    });
  }
  render() {
    const {
      metric,
      secondary,
      initialRender
    } = this.props;
    const {
      scale,
      translateX,
      translateY,
      resized
    } = this.state;
    const primaryFormatter = metric && (metric.tickFormatter || metric.formatter) || (n => n);
    const primaryValue = primaryFormatter((0, _last_value_utils.getLastValue)(metric === null || metric === void 0 ? void 0 : metric.data));
    const styles = {
      container: {},
      inner: {
        top: `${this.state.top || 0}px`,
        left: `${this.state.left || 0}px`,
        transform: `matrix(${scale}, 0, 0, ${scale}, ${translateX}, ${translateY})`
      },
      primary_value: {},
      secondary_value: {}
    };
    if (this.props.backgroundColor) styles.container.backgroundColor = this.props.backgroundColor;
    if (metric && metric.color) styles.primary_value.color = metric.color;
    let primaryLabel;
    if (metric && metric.label) {
      primaryLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__label--primary",
        css: labelPrimaryStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 9
        }
      }, metric.label);
    }
    let secondarySnippet;
    if (secondary) {
      const secondaryFormatter = secondary.formatter || (n => n);
      const secondaryValue = secondaryFormatter((0, _last_value_utils.getLastValue)(secondary.data));
      if (secondary.color) styles.secondary_value.color = secondary.color;
      let secondaryLabel;
      if (secondary.label) {
        secondaryLabel = /*#__PURE__*/_react.default.createElement("div", {
          className: "tvbVisMetric__label--secondary",
          css: labelSecondaryStyle,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 207,
            columnNumber: 11
          }
        }, secondary.label);
      }
      secondarySnippet = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__secondary",
        css: secondaryContainerStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 9
        }
      }, secondaryLabel, /*#__PURE__*/_react.default.createElement("div", {
        style: styles.secondary_value,
        className: "tvbVisMetric__value--secondary",
        css: valueSecondaryStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        dangerouslySetInnerHTML: {
          __html: secondaryValue
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 13
        }
      })));
    }
    let additionalLabel;
    if (this.props.additionalLabel) {
      additionalLabel = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbVisMetric__label--additional",
        css: labelAdditionalStyle,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 230,
          columnNumber: 9
        }
      }, this.props.additionalLabel);
    }
    let className = 'tvbVisMetric';
    if (!this.props.backgroundColor) {
      className += ' tvbVisMetric--noBackground';
    }
    if (this.props.reversed) {
      className += ' tvbVisMetric--reversed';
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
      onResize: this.checkResizeThrottled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 7
      }
    }, resizeRef => /*#__PURE__*/_react.default.createElement(_render_counter.RenderCounter, {
      initialRender: initialRender,
      postponeExecution: !resized,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: className,
      css: containerStyle,
      ref: resizeRef,
      style: styles.container,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.resize = el,
      className: "tvbVisMetric__resize",
      css: resizeStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      ref: el => this.inner = el,
      className: "tvbVisMetric__inner",
      css: innerStyle,
      style: styles.inner,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbVisMetric__primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 19
      }
    }, primaryLabel, /*#__PURE__*/_react.default.createElement("div", {
      style: styles.primary_value,
      "data-test-subj": "tsvbMetricValue",
      className: "tvbVisMetric__value--primary",
      css: valuePrimaryStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      dangerouslySetInnerHTML: {
        __html: primaryValue
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 23
      }
    }))), secondarySnippet, additionalLabel)))));
  }
}
exports.Metric = Metric;
Metric.propTypes = {
  backgroundColor: _propTypes.default.string,
  metric: _propTypes.default.object,
  secondary: _propTypes.default.object,
  reversed: _propTypes.default.bool,
  additionalLabel: _propTypes.default.string
};