"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsFn = void 0;
var _i18n = require("@kbn/i18n");
var _request_handler = require("./request_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createMetricsFn = () => ({
  name: 'tsvb',
  type: 'render',
  inputTypes: ['kibana_context', 'null'],
  help: _i18n.i18n.translate('visTypeTimeseries.function.help', {
    defaultMessage: 'TSVB visualization'
  }),
  args: {
    params: {
      types: ['string'],
      default: '"{}"',
      help: ''
    },
    uiState: {
      types: ['string'],
      default: '"{}"',
      help: ''
    }
  },
  async fn(input, args, {
    getSearchSessionId,
    isSyncColorsEnabled,
    isSyncTooltipsEnabled,
    isSyncCursorEnabled,
    getExecutionContext,
    inspectorAdapters,
    abortSignal: expressionAbortSignal,
    variables
  }) {
    var _isSyncColorsEnabled, _isSyncTooltipsEnable, _isSyncCursorEnabled;
    const visParams = JSON.parse(args.params);
    const uiState = JSON.parse(args.uiState);
    const syncColors = (_isSyncColorsEnabled = isSyncColorsEnabled === null || isSyncColorsEnabled === void 0 ? void 0 : isSyncColorsEnabled()) !== null && _isSyncColorsEnabled !== void 0 ? _isSyncColorsEnabled : false;
    const syncTooltips = (_isSyncTooltipsEnable = isSyncTooltipsEnabled === null || isSyncTooltipsEnabled === void 0 ? void 0 : isSyncTooltipsEnabled()) !== null && _isSyncTooltipsEnable !== void 0 ? _isSyncTooltipsEnable : false;
    const syncCursor = (_isSyncCursorEnabled = isSyncCursorEnabled === null || isSyncCursorEnabled === void 0 ? void 0 : isSyncCursorEnabled()) !== null && _isSyncCursorEnabled !== void 0 ? _isSyncCursorEnabled : true;
    const response = await (0, _request_handler.metricsRequestHandler)({
      input,
      visParams,
      uiState,
      searchSessionId: getSearchSessionId(),
      executionContext: getExecutionContext(),
      inspectorAdapters,
      expressionAbortSignal
    });
    return {
      type: 'render',
      as: 'timeseries_vis',
      value: {
        visParams,
        visData: response,
        syncColors,
        syncTooltips,
        syncCursor,
        canNavigateToLens: variables.canNavigateToLens
      }
    };
  }
});
exports.createMetricsFn = createMetricsFn;