"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfoMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hjson = require("hjson");
var _experimental_map_vis_info = require("./experimental_map_vis_info");
var _deprecated_interval_info = require("./deprecated_interval_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vega/public/components/vega_info_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const parseSpec = spec => {
  if (spec) {
    try {
      return (0, _hjson.parse)(spec, {
        legacyRoot: false,
        keepWsc: true
      });
    } catch (e) {
      // spec is invalid
    }
  }
};
const InfoMessage = ({
  spec
}) => {
  const vegaSpec = (0, _react.useMemo)(() => parseSpec(spec), [spec]);
  if (!vegaSpec) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _experimental_map_vis_info.shouldShowMapLayerInfo)(vegaSpec) && /*#__PURE__*/_react.default.createElement(_experimental_map_vis_info.ExperimentalMapLayerInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 44
    }
  }), (0, _deprecated_interval_info.shouldShowDeprecatedHistogramIntervalInfo)(vegaSpec) && /*#__PURE__*/_react.default.createElement(_deprecated_interval_info.DeprecatedHistogramIntervalInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 63
    }
  }));
};
const getInfoMessage = vis => /*#__PURE__*/_react.default.createElement(InfoMessage, {
  spec: vis.params.spec,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 45
  }
});
exports.getInfoMessage = getInfoMessage;