"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VegaVisComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _vega_visualization = require("../vega_visualization");
var _vega_vis = require("./vega_vis.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vega/public/components/vega_vis_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const vegaVisStyles = {
  wrapperStyles: euiTheme => (0, _react2.css)`
    ${(0, _eui.euiScrollBarStyles)(euiTheme)}
    display: flex;
    flex: 1 1 0;
    overflow: auto;
  `
};
const VegaVisComponent = ({
  visData,
  fireEvent,
  renderComplete,
  deps,
  renderMode
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(vegaVisStyles);
  const chartDiv = (0, _react.useRef)(null);
  const renderCompleted = (0, _react.useRef)(false);
  const visController = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (chartDiv.current) {
      const VegaVis = (0, _vega_visualization.createVegaVisualization)(deps, renderMode);
      visController.current = new VegaVis(chartDiv.current, fireEvent);
    }
    return () => {
      var _visController$curren;
      (_visController$curren = visController.current) === null || _visController$curren === void 0 ? void 0 : _visController$curren.destroy();
      visController.current = null;
    };
  }, [deps, fireEvent, renderMode]);
  (0, _react.useEffect)(() => {
    const asyncRender = async visCtrl => {
      await visCtrl.render(visData);
      renderCompleted.current = true;
      renderComplete();
    };
    if (visController.current) {
      asyncRender(visController.current);
    }
  }, [renderComplete, visData]);
  const onContainerResize = (0, _react.useCallback)(dimensions => {
    if (renderCompleted.current) {
      var _visController$curren2;
      (_visController$curren2 = visController.current) === null || _visController$curren2 === void 0 ? void 0 : _visController$curren2.resize(dimensions);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_vega_vis.GlobalVegaVisStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onContainerResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    css: styles.wrapperStyles,
    ref: resizeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: chartDiv,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }))));
};
exports.VegaVisComponent = VegaVisComponent;