"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vegaLayerId = exports.defaultProjection = exports.defaultMapConfig = exports.defaultMabBoxStyle = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const vegaLayerId = exports.vegaLayerId = 'vega';
const defaultMapConfig = exports.defaultMapConfig = {
  maxZoom: 20,
  minZoom: 0,
  tileSize: 256
};
const defaultMabBoxStyle = exports.defaultMabBoxStyle = {
  /**
   * according to the MapBox documentation that value should be '8'
   * @see (https://docs.mapbox.com/mapbox-gl-js/style-spec/root/#version)
   */
  version: 8,
  sources: {},
  layers: []
};
const defaultProjection = exports.defaultProjection = {
  name: 'projection',
  type: 'mercator',
  scale: {
    signal: '512*pow(2,zoom)/2/PI'
  },
  rotate: [{
    signal: '-longitude'
  }, 0, 0],
  center: [0, {
    signal: 'latitude'
  }],
  translate: [{
    signal: 'width/2'
  }, {
    signal: 'height/2'
  }],
  fit: false
};