"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceSettings = getServiceSettings;
var _service_settings = require("./service_settings");
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getServiceSettings() {
  const mapsEms = (0, _services.getMapsEms)();
  const mapsEmsConfig = mapsEms.config;
  const emsClient = await mapsEms.createEMSClient();
  // any kibana user, regardless of distribution, should get all zoom levels
  // use `sspl` license to indicate this
  emsClient.addQueryParams({
    license: 'sspl'
  });
  return new _service_settings.ServiceSettings(mapsEmsConfig, mapsEmsConfig.tilemap, emsClient);
}