"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Binder = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _d = _interopRequireDefault(require("d3"));
var _jquery = _interopRequireDefault(require("jquery"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class Binder {
  constructor() {
    (0, _defineProperty2.default)(this, "disposal", []);
  }
  on(emitter, ...args) {
    const on = emitter.on || emitter.addListener;
    const off = emitter.off || emitter.removeListener;
    on.apply(emitter, args);
    this.disposal.push(() => off.apply(emitter, args));
  }
  destroy() {
    const destroyers = this.disposal;
    this.disposal = [];
    destroyers.forEach(fn => fn());
  }
  jqOn(el, ...args) {
    const $el = (0, _jquery.default)(el);
    $el.on(...args);
    this.disposal.push(() => $el.off(...args));
  }
  fakeD3Bind(el, event, handler) {
    this.jqOn(el, event, e => {
      // mimic https://github.com/mbostock/d3/blob/3abb00113662463e5c19eb87cd33f6d0ddc23bc0/src/selection/on.js#L87-L94
      const o = _d.default.event; // Events can be reentrant (e.g., focus).
      _d.default.event = e;
      try {
        // @ts-ignore
        handler.apply(this, [this.__data__]);
      } finally {
        _d.default.event = o;
      }
    });
  }
}
exports.Binder = Binder;