"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineOptions = LineOptions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _collections = require("../../../collections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/metrics_axes/line_options.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const interpolationModes = (0, _collections.getInterpolationModes)();
function LineOptions({
  chart,
  setChart
}) {
  const setLineWidth = (0, _react.useCallback)((paramName, value) => {
    setChart(paramName, value === '' ? undefined : value);
  }, [setChart]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.showLineLabel', {
      defaultMessage: 'Show line'
    }),
    paramName: "drawLinesBetweenPoints",
    value: chart.drawLinesBetweenPoints,
    setValue: setChart,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineModeLabel', {
      defaultMessage: 'Line mode'
    }),
    options: interpolationModes,
    paramName: "interpolate",
    value: chart.interpolate,
    setValue: setChart,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    disabled: !chart.drawLinesBetweenPoints,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.series.lineWidthLabel', {
      defaultMessage: 'Line width'
    }),
    paramName: "lineWidth",
    step: 0.5,
    min: 0,
    value: chart.lineWidth,
    setValue: setLineWidth,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }))));
}